% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dlt_curve.R
\name{dlt_curve_d1ph}
\alias{dlt_curve_d1ph}
\title{Plot the DLT curve based on the EWOC proportional hazards model}
\usage{
dlt_curve_d1ph(
  mtd,
  rho,
  theta,
  min_dose,
  max_dose,
  shape,
  tau,
  distribution = "exponential",
  dose_set = NULL
)
}
\arguments{
\item{mtd}{a numerical value indicating the true value of the parameter mtd.}

\item{rho}{a numerical value indicating the true value of the parameter rho.}

\item{theta}{a numerical value defining the proportion of expected patients
to experience a medically unacceptable, dose-limiting toxicity (DLT) if
administered the MTD.}

\item{min_dose}{a numerical value defining the lower bound of the support of
the MTD.}

\item{max_dose}{a numerical value defining the upper bound of the support of
the MTD.}

\item{shape}{a numerical value indicating the true value of the parameter shape.
It is only necessary if 'distribution' = "weibull".}

\item{tau}{a numerical value defining the period of time for a possible
toxicity be observed.}

\item{distribution}{a character establishing the distribution for the time of
events. It can be defined as 'exponential' or 'weibull'.}

\item{dose_set}{a numerical vector of doses that probability of DLT will
be calculated.}
}
\description{
Plot the DLT curve based on the EWOC proportional hazards model
}
