% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcFossilDivTT.R
\name{calcFossilDivTT}
\alias{calcFossilDivTT}
\title{Calculate paleo diversity curves through different methods}
\usage{
calcFossilDivTT(
  data,
  tax.lvl = "species",
  method = "rangethrough",
  bin.reso = 1
)
}
\arguments{
\item{data}{A \code{data.frame} containing the columns: \code{max_ma},
\code{min_ma} and  the name provided in \code{tax.lvl}. \code{max_ma} and
\code{min_ma} are respectively the early and late bounds of rock layer's age.
\code{tax.lvl} column is the taxonomic level of the data. Any additional
columns are ignored.}

\item{tax.lvl}{A \code{character} giving the taxonomic in which
calculations will be based on (default value is \code{"species"}).
This must refer to the column names in \code{data}.}

\item{method}{A \code{character} string setting the method which should be used.
Could be either \code{"rangethrough"} or \code{"stdmethod"}, which will
respectively calculate diversity using the range through or the standard
methods (Foote & Miller, 2007)}

\item{bin.reso}{A \code{numeric} assigning the resolution (length) of the
time bin to consider in calculations. Default value is \code{1} (which in
most cases - e.g. those following the Paleobiology Database default
timescale - will equate to one million years)}
}
\value{
A \code{data.frame} containing the diversity (column \code{div}) of
the chosen taxonomic level through time, with calculation based on
\code{method}. If \code{"method = rangethrough"}, the time moments are the
layer boundaries given in \code{data}.
If \code{"method = stdmethod"}, the time moments are evenly-space bins  with
length equal to \code{bin.reso}, starting at the earliest bound in the
dataset.
}
\description{
\code{calcFossilDivTT} calculates fossil diversity through time using
different methods.
}
\examples{

# Loading data
data("dinos_fossil")

# Using function:
div1 <- calcFossilDivTT(dinos_fossil, method = "stdmethod")
div2 <- calcFossilDivTT(dinos_fossil, method = "stdmethod", bin.reso = 10)

# Comparing different bins sizes in the standard method
plot(x=div1$age, y=div1$div, type="l", 
     xlab = "Time (Mya)", ylab = "Richness", 
     xlim=rev(range(div1$age)), col="red") 
lines(x=div2$age, y=div2$div, col="blue")

# Comparing different methods:
div3 <- calcFossilDivTT(dinos_fossil, method = "rangethrough")
plot(x=div1$age, y=div1$div, type="l", 
     xlab = "Time (Mya)", ylab = "Richness", 
     xlim=rev(range(div1$age)), col="red") 
lines(x=div3$age, y=div3$div, col="blue")

}
\references{
Foote, M., Miller, A. I., Raup, D. M., & Stanley, S. M. (2007). Principles
of paleontology. Macmillan.
}
\author{
Matheus Januario, Jennifer Auler
}
