% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkAndFixUltrametric.R
\name{checkAndFixUltrametric}
\alias{checkAndFixUltrametric}
\title{Find and fix small rounding errors in ultrametric trees}
\usage{
checkAndFixUltrametric(phy)
}
\arguments{
\item{phy}{A \code{phylo} object, following terminology from package
\code{ape} in which function will operate.}
}
\value{
A check and fixed \code{phylo} object.
}
\description{
\code{checkAndFixUltrametric} finds and correct small numerical errors that
might appear in ultrametric trees that where created through simulations.
This function should never be used as a formal statistical method to make a
tree ultrametric, as it was designed just to correct small rounding errors.
}
\examples{
S <- 1
E <- 0
set.seed(1)
phy <- simulateTree(pars = c(S, E), max.taxa = 6, max.t = 5)
phy$edge.length[1] <- phy$edge.length[1]+0.1
ape::is.ultrametric(phy)
phy <- checkAndFixUltrametric(phy)
ape::is.ultrametric(phy)

}
\references{
Paradis, E. (2012). Analysis of Phylogenetics and Evolution with R (Vol. 2).
New York: Springer.

Popescu, A. A., Huber, K. T., & Paradis, E. (2012). ape 3.0: New tools for
distance-based phylogenetics and evolutionary analysis in R. Bioinformatics,
28(11), 1536-1537.
}
\author{
Daniel Rabosky, Matheus Januario, Jennifer Auler
}
