% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Almer.R
\name{Almer}
\alias{Almer}
\title{Linear mixed model with correlated random effects structure}
\usage{
Almer(
  formula,
  data = NULL,
  A = list(),
  REML = TRUE,
  control = lme4::lmerControl(check.nobs.vs.nlev = "ignore", check.nobs.vs.rankZ =
    "ignore", check.nobs.vs.nRE = "ignore"),
  start = NULL,
  verbose = 0L,
  weights = NULL,
  na.action = "na.omit",
  offset = NULL,
  contrasts = NULL,
  devFunOnly = FALSE,
  ...
)
}
\arguments{
\item{formula}{as in \code{\link[lme4]{lmer}}.}

\item{data}{as in \code{\link[lme4]{lmer}}.}

\item{A}{an optional named list of sparse matrices. The names must correspond
to the names of the random effects in the formula argument. All levels of
the random effect should appear as row and column names for the matrices.}

\item{REML}{as in \code{\link[lme4]{lmer}}.}

\item{control}{as in \code{\link[lme4]{lmer}}.}

\item{start}{as in \code{\link[lme4]{lmer}}.}

\item{verbose}{as in \code{\link[lme4]{lmer}}.}

\item{weights}{as in \code{\link[lme4]{lmer}}.}

\item{na.action}{as in \code{\link[lme4]{lmer}}.}

\item{offset}{as in \code{\link[lme4]{lmer}}.}

\item{contrasts}{as in \code{\link[lme4]{lmer}}.}

\item{devFunOnly}{as in \code{\link[lme4]{lmer}}.}

\item{...}{as in \code{\link[lme4]{lmer}}.}
}
\value{
\code{Almer} an object of class \code{\link[lme4]{merMod}}.
}
\description{
\code{Almer} fits a univariate linear mixed model incorporating a correlated
random effects structure. Can be used to fit phylogenetic mixed models and
animal models. The function is based on the \code{\link[lme4]{lme4}} package and is
very similar to \code{\link[lme4]{lmer}}, apart from the A argument.
}
\examples{
# See the vignette 'Phylogenetic mixed model'.
}
\author{
Geir H. Bolstad
}
