% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lr_tests.R
\name{lr_test}
\alias{lr_test}
\title{Likelihood ratio test for individual variables of evzinb}
\usage{
lr_test(
  object,
  vars,
  single = TRUE,
  bootstrap = FALSE,
  multicore = FALSE,
  ncores = NULL,
  verbose = FALSE
)
}
\arguments{
\item{object}{EVZINB or EVZINB object to perform likelihood ratio test on}

\item{vars}{Either a list of character vectors with variable names which to be restricted in the LR test or a character vector of variable names. If a list, each character vector of the list will be run separately, allowing for multiple variables to be restricted as once. If a character vector, parameter 'single' can be used to determine whether all variables in the vector should be restricted at once (single = FALSE) or if the variables should be restricted one by one (single = TRUE)}

\item{single}{Logical. Determining whether variables in 'vars' should be restricted individually (single = TRUE) or all at once (single = FALSE)}

\item{bootstrap}{Should LR tests be conducted on each bootstrapped sample or only on the original sample.}

\item{multicore}{Logical. Should the function be run in parallel?}

\item{ncores}{Number of cores to use if multicore = TRUE}

\item{verbose}{Logical. Should the function be verbose?}
}
\value{
A tibble with one row per performed LR test
}
\description{
Likelihood ratio test for individual variables of evzinb
}
\examples{
data(genevzinb2)
model <- evzinb(y~x1+x2+x3,data=genevzinb2, n_bootstraps = 10)
 lr_test(model,'x1')
 
}
