## ----setup, include = FALSE---------------------------------------------------
library(evidenceratio)
library(ggplot2)

knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  fig.width = 6,
  fig.height = 4
)

## ----chunk-1------------------------------------------------------------------
x <- sleep$extra[sleep$group == 1]
res_a <- evidence_test(x)
res_a

## ----chunk-2------------------------------------------------------------------
y <- sleep$extra[sleep$group == 2]
res_b <- evidence_test(x, y)
res_b

## ----chunk-3------------------------------------------------------------------
tbl <- matrix(
c(30, 70,
20, 80),
nrow = 2,
byrow = TRUE
)
res_c <- evidence_test(tbl)
res_c

## ----chunk-4------------------------------------------------------------------
res_d <- evidence_test(
mpg ~ wt,
data = mtcars,
coef = "wt"
)
res_d

## ----chunk-5------------------------------------------------------------------
joint_df <- data.frame(
panel = factor(
c("A", "B", "C", "D"),
levels = rev(c("A", "B", "C", "D"))
),
label = c(
"One sample mean",
"Two sample comparison",
"Binary endpoint",
"Biomarker association"
),
estimate = c(
res_a$estimate,
res_b$estimate,
res_c$estimate,
res_d$estimate
),
lower = c(
res_a$interval[1],
res_b$interval[1],
res_c$interval[1],
res_d$interval[1]
),
upper = c(
res_a$interval[2],
res_b$interval[2],
res_c$interval[2],
res_d$interval[2]
),
log10_er = c(
res_a$log10_er,
res_b$log10_er,
res_c$log10_er,
res_d$log10_er
)
)

ggplot(joint_df, aes(y = panel, x = estimate)) +
geom_vline(xintercept = 0, linetype = "dashed") +
geom_errorbarh(aes(xmin = lower, xmax = upper), height = 0.25) +
geom_point(size = 2) +
geom_text(
aes(x = upper, label = paste0("log10 ER = ", round(log10_er, 2))),
hjust = -0.1,
size = 3
) +
geom_text(
aes(x = max(upper) * 4, label = label),
hjust = 0,
size = 3
) +
scale_x_continuous(expand = expansion(mult = c(0.05, 0.6))) +
labs(
x = "Effect estimate",
y = ""
)

## ----chunk-6------------------------------------------------------------------
results <- list(
primary_endpoint   = res_b,
secondary_endpoint = res_a,
safety_endpoint    = res_c,
biomarker_model    = res_d
)

forest_df <- data.frame(
endpoint = factor(names(results), levels = rev(names(results))),
estimate = sapply(results, function(r) r$estimate),
lower = sapply(results, function(r) r$interval[1]),
upper = sapply(results, function(r) r$interval[2]),
log10_er = sapply(results, function(r) r$log10_er)
)

ggplot(forest_df, aes(y = endpoint, x = estimate)) +
geom_vline(xintercept = 0, linetype = "dashed") +
geom_errorbarh(aes(xmin = lower, xmax = upper), height = 0.2) +
geom_point(size = 2) +
geom_text(
aes(x = upper, label = paste0("log10 ER = ", round(log10_er, 2))),
hjust = -0.1,
size = 3
) +
labs(
x = "Effect estimate",
y = ""
) +
xlim(-7, 7)

