% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/percent_map_operator.R
\name{\%map\%}
\alias{\%map\%}
\title{\%map\%: Case-insensitive mapping returning named vector}
\usage{
x \%map\% table
}
\arguments{
\item{x}{Character vector of input strings.}

\item{table}{Character vector to match against.}
}
\value{
A named character vector. Names are from matched \code{table} values, values are from \code{x}.
If no matches are found, returns a zero-length named character vector.
}
\description{
Performs case-insensitive matching between elements in \code{x} and entries in \code{table},
returning a named character vector: names are the matched entries from \code{table},
values are the original elements from \code{x}.
Unmatched values are ignored (not included in the result).
}
\examples{
# Basic matching (case-insensitive)
c("tp53", "brca1", "egfr") \%map\% c("TP53", "EGFR", "MYC")
# returns: Named vector: TP53 = "tp53", EGFR = "egfr"

# Values not in table are dropped
c("akt1", "tp53") \%map\% c("TP53", "EGFR")
# returns: TP53 = "tp53"

# All unmatched values returns: empty result
c("none1", "none2") \%map\% c("TP53", "EGFR")
# returns: character(0)
}
