% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PAPDcv.R
\name{PAPDcv}
\alias{PAPDcv}
\title{Estimation of the Population Average Prescription Difference in Randomized Experiments Under Cross Validation}
\usage{
PAPDcv(T, Thatfp, Thatgp, Y, ind, budget, centered = TRUE)
}
\arguments{
\item{T}{A vector of the unit-level binary treatment receipt variable for each sample.}

\item{Thatfp}{A matrix where the \code{i}th column is the unit-level binary treatment that would have been assigned by the first
individualized treatment rule generated in the \code{i}th fold. Please ensure
that the percentage of treatment units of That is lower than the budget constraint.}

\item{Thatgp}{A matrix where the \code{i}th column is the unit-level binary treatment that would have been assigned by the second
individualized treatment rule generated in the \code{i}th fold. Please ensure
that the percentage of treatment units of That is lower than the budget constraint.}

\item{Y}{The outcome variable of interest.}

\item{ind}{A vector of integers (between 1 and number of folds inclusive) indicating which testing set does each sample belong to.}

\item{budget}{The maximum percentage of population that can be treated under the
budget constraint. Should be a decimal between 0 and 1.}

\item{centered}{If \code{TRUE}, the outcome variables would be centered before processing. This minimizes
the variance of the estimator. Default is \code{TRUE}.}
}
\value{
A list that contains the following items: \item{papd}{The estimated
Population Average Prescription Difference.} \item{sd}{The estimated standard deviation
of PAPD.}
}
\description{
This function estimates the Population Average Prescription Difference with a budget constaint under cross validation. The details of the methods for this design are given in Imai and Li (2019).
}
\examples{
T = c(1,0,1,0,1,0,1,0)
That = matrix(c(0,1,1,0,0,1,1,0,1,0,0,1,1,0,0,1), nrow = 8, ncol = 2)
That2 = matrix(c(0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0), nrow = 8, ncol = 2)
Y = c(4,5,0,2,4,1,-4,3)
ind = c(rep(1,4),rep(2,4))
papdlist <- PAPDcv(T, That, That2, Y, ind, budget = 0.5)
papdlist$papd
papdlist$sd
}
\references{
Imai and Li (2019). \dQuote{Experimental Evaluation of Individualized Treatment Rules},
}
\author{
Michael Lingzhi Li, Technology and Operations Management, Harvard Business School
\email{mili@hbs.edu}, \url{https://www.michaellz.com/};
}
\keyword{evaluation}
