% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GATEcv.R
\name{GATEcv}
\alias{GATEcv}
\title{Estimation of the Grouped Average Treatment Effects (GATEs) in Randomized Experiments Under Cross Validation}
\usage{
GATEcv(T, tau, Y, ind, ngates = 5)
}
\arguments{
\item{T}{A vector of the unit-level binary treatment receipt variable for each sample.}

\item{tau}{A matrix where the \code{i}th column is the unit-level continuous score for treatment assignment generated in the \code{i}th fold. Conditional Average Treatment Effect is one possible measure.}

\item{Y}{A vector of the outcome variable of interest for each sample.}

\item{ind}{A vector of integers (between 1 and number of folds inclusive) indicating which testing set does each sample belong to.}

\item{ngates}{The number of groups to separate the data into. The groups are determined by \code{tau}. Default is 5.}
}
\value{
A list that contains the following items: \item{gate}{The estimated
vector of GATEs under cross-validation of length \code{ngates} arranged in order of increasing \code{tau}.} \item{sd}{The estimated vector of standard deviation
of GATEs under cross-validation.}
}
\description{
This function estimates the Grouped Average Treatment Effects (GATEs) under cross-validation where the groups are determined by a continuous score. The details of the methods for this design are given in Imai and Li (2022).
}
\examples{
T = c(1,0,1,0,1,0,1,0)
tau = matrix(c(0,0.1,0.2,0.3,0.4,0.5,0.6,0.7,-0.5,-0.3,-0.1,0.1,0.3,0.5,0.7,0.9),nrow = 8, ncol = 2)
Y = c(4,5,0,2,4,1,-4,3)
ind = c(rep(1,4),rep(2,4))
gatelist <- GATEcv(T, tau, Y, ind, ngates = 2)
gatelist$gate
gatelist$sd
}
\references{
Imai and Li (2022). \dQuote{Statistical Inference for Heterogeneous Treatment Effects Discovered by Generic Machine Learning in Randomized Experiments},
}
\author{
Michael Lingzhi Li, Technology and Operations Management, Harvard Business School
\email{mili@hbs.edu}, \url{https://www.michaellz.com/};
}
\keyword{evaluation}
