% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wooldridge.R
\name{wooldridge}
\alias{wooldridge}
\title{Wooldridge Estimation of Production Functions (Cobb-Douglas)}
\usage{
wooldridge(
  data,
  formula = y ~ free | capital | proxy | controls,
  gross = FALSE,
  id = "id",
  time = "year",
  bootstrap = FALSE,
  reps = 2,
  degree = c(3, 2),
  verify = TRUE,
  ...
)
}
\arguments{
\item{data}{A data.frame or tibble containing the variables of the model.}

\item{formula}{An object of the class \code{\link[stats]{formula}}.}

\item{gross}{If TRUE dependent variable is gross output.}

\item{id}{A character with the name of the indicator variable.}

\item{time}{A character with the name of the time variable.}

\item{bootstrap}{An optional logical. If TRUE calculate bootstrap standard errors.}

\item{reps}{The number of bootstrap replications.}

\item{degree}{A vector with the number of the polynomial interactions in each stage of the routine.}

\item{verify}{Verify if inputs are sorted.}

\item{...}{Additional arguments.}
}
\description{
This function aims the estimation of Cobb-Douglas production functions using \href{https://doi.org/10.1016/j.econlet.2009.04.026}{Wooldridge (2009)} method.
}
\details{
Multipart formula must be specified in the following order: \code{y ~ free | capital | proxy | controls}. Additional controls are optional.
It is possible to use more than one variable, although the use of more than one capital may not be theoretically identified.
The function returns an object of the estprod or boot classes (if \code{bootstrap} is TRUE).
}
\examples{
data(estprod_data)
wooldridge(data = estprod_data, var1 ~ var2 | var3 | var4, 
id = "id", time = "year", bootstrap = TRUE)
}
