% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setREF.R
\name{setREF}
\alias{setREF}
\title{setREF}
\usage{
setREF(MAXPROMPT = NULL, REFVN = NULL)
}
\arguments{
\item{MAXPROMPT}{a numeric value. The number of prompts per day.}

\item{REFVN}{a list. Each element of the list must specify one of the relevant column names of the reference dataset; i.e. the identification number (e.g. ID), the IMEI number, the character substring that all columns have in common which specify the prompt time, the start date, the start time, the end date, and the end time. Use function \code{\link{relevantREFVN}} to generate \code{REFVN}.}
}
\value{
A list. Each element of the list is named according to the variable's content. See \strong{Details} for more information.
}
\description{
setREF sets the relevant variable names concerning the reference dataset.
}
\details{
The list is named "RELEVANTVN_REF". It contains either 5 or 7 elements, depending on whether the start date and the start time already exist as a date-time object (same for end date and end time). In the latter case the list elements' names are:
\enumerate{
\item REF_ID: the column name in the reference dataset holding the name of the unique participant identification code.
\item REF_IMEI: the column name in the reference dataset holding the IMEI number.
\item REF_ST: the column name in the reference dataset holding the scheduled times (st)/prompts, except for the numeric end of the column name.
\item REF_START_DATETIME: the date-time object of when the very first ESM questionnaire was scheduled/prompted.
\item REF_END_DATETIME: the date-time object of when the very last ESM questionnaire was scheduled/prompted.
}
If the start date and start time (same for end date and end time) are separated, the list elements will be
\enumerate{
\item REF_ID: the column name in the reference dataset holding the name of the unique participant identification code.
\item REF_IMEI: the column name in the reference dataset holding the IMEI number.
\item REF_ST: the column name in the reference dataset holding the scheduled times (st)/prompts, except for the numeric end of the column name.
\item REF_START_DATE: the date of when the very first ESM questionnaire was scheduled/prompted.
\item REF_START_TIME: the time of when the very first ESM questionnaire was scheduled/prompted.
\item REF_END_DATE the date of when the very last ESM questionnaire was scheduled/prompted.
\item REF_END_TIME the time of when the very last ESM questionnaire was scheduled/prompted.
}
The last element of the output list will always be "REF_DATETIMES_SEP": TRUE if date and time are separated, FALSE if they are a single date-time object.
}
\examples{
# o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o
# Prerequisites in order to execute setREF. Start  ------------------
relRef <- relevantREFVN(ID="id", IMEI="imei", ST="st",
STARTDATE="start_date", STARTTIME="start_time",
ENDDATE="end_date", ENDTIME="end_time")
# Prerequisites in order to execute setREF. End ---------------------
# ------------------------------------------------------
# Run function 2 of 29; see esmprep functions' hierarchy.
# ------------------------------------------------------
# 4 is the number of daily prompts.
# relRef is the result of function 'relevantREFVN'
# Relevant variables names of reference dataset.
(RELEVANTVN_REF <- setREF(4, relRef))
# With date-time objects instead of separate date and time
relRef <- relevantREFVN(ID="id", IMEI="imei", ST="st",
START_DATETIME="start_dateTime", END_DATETIME="end_dateTime")
(RELEVANTVN_REF <- setREF(4, relRef))
# o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o
}
\seealso{
Exemplary code (fully executable) in the documentation of \code{\link{esmprep}} (function 2 of 29).
}
