% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/printSuggestedShift.R
\name{printSuggestedShift}
\alias{printSuggestedShift}
\title{printSuggestedShift}
\usage{
printSuggestedShift(esDfShift, RELEVANTVN_ES = NULL)
}
\arguments{
\item{esDfShift}{a list. Each element of the list must be a data.frame. This argument is generated by \code{\link{suggestShift}} if at least one ESM questionnaire is eligible for shifting to a neighboring prompt. See \strong{Details} for more information.}

\item{RELEVANTVN_ES}{a list. This list is generated by function \code{\link{setES}} and it is extended once either by function \code{\link{genDateTime}} or by function \code{\link{splitDateTime}}.}
}
\value{
No return value. See \strong{Details} for more information.
}
\description{
printSuggestedShift prints to the console which ESM prompts are suggested to be modified.
}
\details{
The output to the console shall give the user the necessary information to decide whether lines of data might be shifted and where they shall be shifted to (by altering the values of the variable PROMPT) .
}
\examples{
# o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o
# Prerequisites in order to execute printSuggestedShift. Start ------
# Use example list delivered with the package
RELEVANTINFO_ES <- RELEVANTINFO_ES
# Use example list delivered with the package
RELEVANTVN_ES <- RELEVANTVN_ESext
# esAssigned is a list of datasets, delivered with the package. It is
# the result of the assignment of the ESM questionnaires to ALL 8
# participants in the reference dataset.
noEndDf <- missingEndDateTime(esAssigned[["ES"]], RELEVANTVN_ES)
identDf <- esIdentical(noEndDf, RELEVANTVN_ES)
sugShift <- suggestShift(identDf, 100, RELEVANTINFO_ES, RELEVANTVN_ES)
# Prerequisites in order to execute printSuggestedShift. End --------
# -------------------------------------------------------
# Run function 21 of 29; see esmprep functions' hierarchy.
# -------------------------------------------------------
# Display the result of function 'suggestShift' in the console.
printSuggestedShift(sugShift, RELEVANTVN_ES)
# o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o
}
\seealso{
Exemplary code (fully executable) in the documentation of \code{\link{esmprep}} (function 21 of 29).
}
