% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trialr_nbg_selector.R
\name{get_trialr_nbg}
\alias{get_trialr_nbg}
\title{Get an object to fit the NBG dose-finding model using the trialr package.}
\usage{
get_trialr_nbg(
  parent_selector_factory = NULL,
  real_doses,
  d_star,
  target,
  alpha_mean,
  alpha_sd,
  beta_mean,
  beta_sd,
  tite = FALSE,
  ...
)
}
\arguments{
\item{parent_selector_factory}{optional object of type
\code{\link{selector_factory}} that is in charge of dose selection before
this class gets involved. Leave as NULL to just use this model from the start.}

\item{real_doses}{Doses under investigation, a non-decreasing vector of
numbers.}

\item{d_star}{Numeric, reference dose for calculating the covariate
\code{log(dose / d_star)} when fitting the model. Sometimes (but not always)
taken to be the max dose in real_doses.}

\item{target}{We seek a dose with this probability of toxicity.}

\item{alpha_mean}{Prior mean of intercept variable for normal prior.
See Details. Also see documentation for trialr package for further details.}

\item{alpha_sd}{Prior standard deviation of intercept variable for normal prior.
See Details. Also see documentation for trialr package for further details.}

\item{beta_mean}{Prior mean of gradient variable for normal prior.
See Details. Also see documentation for trialr package for further details.}

\item{beta_sd}{Prior standard deviation of slope variable for normal prior.
See Details. Also see documentation for trialr package for further details.}

\item{tite}{FALSE to use regular model; TRUE to use TITE version See
Description.}

\item{...}{Extra args are passed to \code{\link[trialr]{stan_nbg}}.}
}
\value{
an object of type \code{\link{selector_factory}} that can fit the
NBG model to outcomes.
}
\description{
This function returns an object that can be used to fit a Neuenschwander,
Branson and Gsponer (NBG) model for dose-finding using methods provided by
the trialr package.
}
\details{
The model form implemented in trialr is:

\eqn{F(x_{i}, \alpha, \beta) = 1 / (1 + \exp{-(\alpha + \exp{(\beta)} log(x_i / d_*))}) }

with normal priors on alpha and beta.

Dose selectors are designed to be daisy-chained together to achieve different
behaviours. This class is a **resumptive** selector, meaning it carries on
when the previous dose selector, where present, has elected not to continue.
For example, this allows instances of this class to be preceded by a selector
that follows a fixed path in an initial escalation plan, such as that
provided by \code{\link{follow_path}}. In this example, when the observed
trial outcomes deviate from that initial plan, the selector following the
fixed path elects not to continue and responsibility passes to this class.
See examples under \code{\link{get_dfcrm}}.

A time-to-event variant, like TITE-CRM, is used when you specify
\code{tite = TRUE}. This weights the observations to allow dose-selections
based on partially observed outcomes.
}
\examples{
real_doses <- c(5, 10, 25, 40, 60)
d_star <- 60
target <- 0.25

model <- get_trialr_nbg(real_doses = real_doses, d_star = d_star,
                        target = target,
                        alpha_mean = 2, alpha_sd = 1,
                        beta_mean = 0.5, beta_sd = 1)
# Refer to the trialr documentation for more details on model & priors.
outcomes <- '1NNN 2NTN'
fit <- model \%>\% fit(outcomes)
fit \%>\% recommended_dose()
fit \%>\% mean_prob_tox()

}
\references{
Neuenschwander, B., Branson, M., & Gsponer, T. (2008).
Critical aspects of the Bayesian approach to phase I cancer trials.
Statistics in Medicine, 27, 2420–2439. https://doi.org/10.1002/sim.3230

Brock, K. (2020). trialr: Clinical Trial Designs in 'rstan'.
R package version 0.1.5. https://github.com/brockk/trialr

Brock, K. (2019). trialr: Bayesian Clinical Trial Designs in R and Stan.
arXiv preprint arXiv:1907.00161.
}
