% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.R, R/InitWtErgmTerm.R
\name{b2cov-ergmTerm}
\alias{b2cov-ergmTerm}
\alias{InitErgmTerm.b2cov}
\alias{InitWtErgmTerm.b2cov}
\title{Main effect of a covariate for the second mode in a bipartite  network}
\usage{
# binary: b2cov(attr)

# valued: b2cov(attr, form="sum")
}
\arguments{
\item{attr}{a vertex attribute specification (see Specifying Vertex attributes and Levels (\code{?nodal_attributes}) for details.)}

\item{form}{how to aggregate tie values in a valued ERGM: \code{"sum"}
(the default) for a statistic of the form \eqn{\sum_{i,j} x_{i,j}
  y_{i,j}}{sum[i,j] x[i,j]*y[i,j]}, where \eqn{y_{i,j}}{y[i,j]} is
the value of dyad \eqn{(i,j)} and \eqn{x_{i,j}}{x[i,j]} is the
term's covariate associated with it; and \code{"nonzero"} with the
edge considered to be present if its value is not 0. See
\code{\link{ergmTerm}} for more information.}
}
\description{
This term adds a single network statistic for each quantitative attribute or matrix column to the model equaling the total
value of \code{attr(j)} for all edges \eqn{(i,j)} in the network. This
term may only be used with bipartite networks. For categorical attributes, see \code{b2factor}.
}
\note{
\pkg{ergm} versions 3.9.4 and earlier used different arguments for this
term. See \code{\link{ergm-options}} for how to invoke the old behaviour.
}
\seealso{
\code{\link{ergmTerm}} for index of model terms currently visible to the package.

\Sexpr[results=rd,stage=render]{ergm:::.formatTermKeywords("ergmTerm", "b2cov", "subsection")}
}
\concept{bipartite}
\concept{dyad-independent}
\concept{frequently-used}
\concept{quantitative nodal attribute}
\concept{undirected}
