% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/final_size.R
\name{R02AR}
\alias{R02AR}
\title{Title Calculate attack rate from basic reproduction number}
\usage{
R02AR(R0, tol = 0.01)
}
\arguments{
\item{R0}{a value or vector of values representing the basic reproduction 
number, must be >=0}

\item{tol}{a single >=0 value giving the tolerance for the calculated attack 
rate}
}
\value{
AR, the attack rate, calculated using the relationship: 
R0 = -log(1-AR)/AR
}
\description{
Title Calculate attack rate from basic reproduction number
}
\examples{

## Calculate the attack rate for a specific value of the reproduction number
R02AR(2) # returns the AR for an R0 of 2

## plot the relationship between R0 and attack rate
x <- seq(1.01, 5, 0.01)
plot(x, R02AR(x), type = "l", xlab = "R0", ylab = "Attack rate")

}
