% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filesystem.R
\name{clear_old_reports}
\alias{clear_old_reports}
\title{Clear out old reports before generating new ones.}
\usage{
clear_old_reports(internal, public)
}
\arguments{
\item{internal}{Filepath. Folder for internal reports.}

\item{public}{Filepath. Folder for public reports.}
}
\value{
The list of old reports that were cleared.
}
\description{
\code{clear_old_reports} deletes reports from previous runs and returns a list of
the reports that were deleted.
}
\examples{
ireports_folder <- file.path(tempdir(), "internal")
preports_folder <- file.path(tempdir(), "public")
dir.create(ireports_folder)
dir.create(preports_folder)

clear_old_reports(ireports_folder, preports_folder)
unlink(c(ireports_folder, preports_folder), recursive = TRUE)
}
