% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sadie.R
\name{sadie}
\alias{sadie}
\alias{sadie.data.frame}
\alias{sadie.matrix}
\alias{sadie.count}
\alias{sadie.incidence}
\title{Spatial Analysis by Distance IndicEs (SADIE).}
\usage{
sadie(data, ...)

\method{sadie}{data.frame}(
  data,
  index = c("Perry", "Li-Madden-Xu", "all"),
  nperm = 100,
  seed = NULL,
  threads = 1,
  ...,
  method = "shortsimplex",
  verbose = TRUE
)

\method{sadie}{matrix}(
  data,
  index = c("Perry", "Li-Madden-Xu", "all"),
  nperm = 100,
  seed = NULL,
  threads = 1,
  ...,
  method = "shortsimplex",
  verbose = TRUE
)

\method{sadie}{count}(
  data,
  index = c("Perry", "Li-Madden-Xu", "all"),
  nperm = 100,
  seed = NULL,
  threads = 1,
  ...,
  method = "shortsimplex",
  verbose = TRUE
)

\method{sadie}{incidence}(
  data,
  index = c("Perry", "Li-Madden-Xu", "all"),
  nperm = 100,
  seed = NULL,
  threads = 1,
  ...,
  method = "shortsimplex",
  verbose = TRUE
)
}
\arguments{
\item{data}{A data frame or a matrix with only three columns: the two first
ones must be the x and y coordinates of the sampling units, and the last
one, the corresponding disease intensity observations. It can also be a
\code{\link{count}} or an \code{\link{incidence}} object.}

\item{...}{Additional arguments to be passed to other methods.}

\item{index}{The index to be calculated: "Perry", "Li-Madden-Xu" or "all".
By default, only Perry's index is computed for each sampling unit.}

\item{nperm}{Number of random permutations to assess probabilities.}

\item{seed}{Fixed seed to be used for randomizations (only useful for
checking purposes). Not fixed by default (= NULL).}

\item{threads}{Number of threads to perform the computations.}

\item{method}{Method for the transportation algorithm.}

\item{verbose}{Explain what is being done (TRUE by default).}
}
\value{
A \code{sadie} object.
}
\description{
\code{sadie} performs the SADIE procedure. It computes different indices and
probabilities based on the distance to regularity for the observed spatial
pattern and a specified number of random permutations of this pattern. Both
kind of clustering indices described by Perry et al. (1999) and Li et al.
(2012) can be computed.
}
\details{
By convention in the SADIE procedure, clustering indices for a donor unit
(outflow) and a receiver unit (inflow) are positive and negative in sign,
respectively.
}
\examples{
set.seed(123)
# Create an intensity object:
my_count <- count(aphids, mapping(x = xm, y = ym))
# Only compute Perry's indices:
my_res <- sadie(my_count)
my_res
summary(my_res)
plot(my_res)
plot(my_res, isoclines = TRUE)

set.seed(123)
# Compute both Perry's and Li-Madden-Xu's indices (using multithreading):
my_res <- sadie(my_count, index = "all", threads = 2, nperm = 20)
my_res
summary(my_res)
plot(my_res) # Identical to: plot(my_res, index = "Perry")
plot(my_res, index = "Li-Madden-Xu")

set.seed(123)
# Using usual data frames instead of intensity objects:
my_df <- aphids[, c("xm", "ym", "i")]
sadie(my_df)

}
\references{
Perry JN. 1995. Spatial analysis by distance indices. Journal of Animal
Ecology 64, 303–314. \doi{10.2307/5892}

Perry JN, Winder L, Holland JM, Alston RD. 1999. Red–blue plots for detecting
clusters in count data. Ecology Letters 2, 106–113.
\doi{10.1046/j.1461-0248.1999.22057.x}

Li B, Madden LV, Xu X. 2012. Spatial analysis by distance indices: an
alternative local clustering index for studying spatial patterns. Methods in
Ecology and Evolution 3, 368–377.
\doi{10.1111/j.2041-210X.2011.00165.x}
}
