% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intensity-classes.R
\name{intensity}
\alias{intensity}
\alias{count}
\alias{count_data}
\alias{incidence}
\alias{incidence_data}
\alias{severity}
\alias{severity_data}
\title{Construct count, incidence and severity objects.}
\usage{
count(data, mapping, keep_only_std = TRUE)

incidence(data, mapping, keep_only_std = TRUE)

severity(data, mapping, keep_only_std = TRUE)
}
\arguments{
\item{data}{A data frame. Each line corresponds to a record (or case, or
entry).}

\item{mapping}{A \code{mapping} object, created with \code{mapping()} or
  \code{mapping_()} functions. ... A vector with all the corresponding variables. The different
elements can be named (names of the elements) of the data frame in the
incidence object), or unamed. In the latter case, elements must be
correctly ordered, i.e. x, y, z, t, r and then n. If variables in NULL,
then only the 6 first ... will be take into account in the following (1, 2,
...), i.e. the id of the value. All the 'parameters' need to be specified.}

\item{keep_only_std}{Are only standard names kept when proceeding to mapping?
Setting \code{keep_only_std} to TRUE may be useful for subsequent data splitting
using extra labels.}
}
\value{
An \code{intensity} object.

When printed, difference information are available:

\itemize{
    \item The number of sampling units.
    \item The time.
    \item Is it georeferenced (TRUE/FALSE)
    \item Are there any NA data (TRUE/FALSE)
    \item Is it a complet array (TRUE/FALSE)? A complete array means that all the recorded values allow to
    display an array (even if some data are not available), but this was explicitelly specified. To
    complete a dataset, just use \code{complete(data)}. You can also remove NA, which is necessary to use
    some analysis technics, using \code{replaceNA(data)} or \code{replace.na(data)}. Note that using both
    commands will results in modifying the original data sets which will be specified.
}
}
\description{
\code{count()}, \code{incidence()} and \code{severity()} create eponym
objects. All of these classes inherit from the base class \code{intensity}.
The choice of the class depends on the nature of the data set.
}
\details{
\code{incidence} reads disease incidence data from a data frame and return an
incidence object. All of these classes inherit from \code{intensity} class.
\itemize{
    \item count: Each sampling unit contains from 0 to theoreticaly an infinity of data.
    Number are positive integers.
    \item incidence: Each sampling unit contains an number of diseased plants,
    ranging from 0 to \code{n} which is the total amount of plants per sampling
    unit.
    \item severity: Each sampling unit contain a percentage of disease, a positive
    real number ranging from 0.0 to 1.0.
}

Class intensity and inherited classes

All the classes recording disease intensity measurements inherit from this
class. The class \code{intensity} is virtual which means that no object of a
class \code{intensity} can be constructed. This class only describes common
features of all the different disease intensity measurements implemented in
this package (\code{\link{count}}, \code{\link{incidence}} and
\code{\link{severity}}). You should call one of these inherited classes
instead, depending on the nature of your data.

By convention, the first columns of the different data frames of each slots
have names, but the spatial, temporal or even disease information do not need
to fit to these conventions or may be less straightforward and need more
columns to record correctly all the information. In such unusual situations,
the automatic options of the analysis tools would need to be overridden to be
able to work in the desired way.

The differences between the different inherited classes regard only the
\code{obs} slot. In the case of \code{\link{count}}, the data expected for
each record are positive integers (N+). For \code{\link{incidence}}, the data
sets are supposed to be two information set per records, the number of
diseased unit per sampling unit (r) and the total number of units per
sampling unit (n). Note that in its current implementation, n is supposed to
be the same for a whole data set. Unequal sampling units are not implemented
yet. Finally, for \code{\link{severity}}, r is positive real ranging from 0
to 1 and depecting a percentage.

space A data frame containing only spatial information. Each row
  corresponds to a sampling unit. By convention, the first 3 columns are
  names \code{x}, \code{y}, \code{z}.

time A data frame containing temporal information. By convention, the
  first column is named \code{t}.

obs A data frame containing disease observations themselves. The name
  of the columns may differ between the sub-class chosed to record the data.

Note that it is possible to create a "severity" object but no statistical
tools are currently implemented to deal with such an object.

An \code{intensity} object contains at very least the "pure" intensity
records (column \code{r}) which is a so-called observational variable.
Another observational variable, the number of individuals in a sampling unit
(\code{n}), is present in the case of a \code{incidence} object. Very often
in addition to observational variables, there are spatial (columns \code{x},
\code{y} and/or \code{z}) and/or temporal (column \code{t}) variables.

Note that the \code{severity} class and the \code{z} variable (the 3rd
spatial dimension) are implemented but no statistical methods use them at
this point.
}
\examples{
## Create intensity objects
# Implicite call: The variable mapping does not need to be specified if the
# column names of the input data frame follow the default names.
colnames(tomato_tswv$field_1929) # Returns c("x", "y", "t", "i", "n")
my_incidence_1 <- incidence(tomato_tswv$field_1929)
my_incidence_1
my_incidence_2 <- incidence(tomato_tswv$field_1929,
                            mapping(x = x, y = y, t = t, i = i, n = n))
identical(my_incidence_1, my_incidence_2)

# Explicite call: Otherwise, the variable mapping need to be specified, at
# least for column names that do not correspond to default names.
colnames(aphids) # Returns c("xm", "ym", "i")
my_count_1 <- count(aphids, mapping(x = xm, y = ym, i = i))
my_count_1
# We can drop the "i = i" in the mapping.
my_count_2 <- count(aphids, mapping(x = xm, y = ym))
identical(my_count_1, my_count_2)

# It is possible to change the variable mapping after the creation of an
# intensity object:
another_incidence <- incidence(hop_viruses$HpLV)
another_incidence
remap(another_incidence, mapping(x = xm, y = ym))

## Plotting data
plot(my_incidence_1) # Same as: plot(my_incidence_1, type = "spatial")
plot(my_incidence_1, type = "temporal")

plot(my_count_1, tile = FALSE, size = 5)
plot(my_count_1, type = "temporal") # Not possible: there is only 1 date.

# Using grayscale:
plot(my_count_1, grayscale = TRUE)
plot(my_count_1, grayscale = TRUE, tile = FALSE, size = 5)

}
