% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epichains.R
\name{print.epichains}
\alias{print.epichains}
\title{Print an \verb{<epichains>} object}
\usage{
\method{print}{epichains}(x, ...)
}
\arguments{
\item{x}{An \verb{<epichains>} object.}

\item{...}{Other parameters passed to \code{print()}.}
}
\value{
Invisibly returns an \verb{<epichains>}. Called for
side-effects.
}
\description{
Print an \verb{<epichains>} object
}
\examples{
# Using a Poisson offspring distribution and simulating from an infinite
# population up to chain size 10.
set.seed(32)
chains_pois_offspring <- simulate_chains(
  n_chains = 10,
  statistic = "size",
  offspring_dist = rpois,
  stat_threshold = 10,
  generation_time = function(n) rep(3, n),
  lambda = 2
)
chains_pois_offspring # Print the object
}
\author{
James M. Azam
}
