% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epe4md_proj_geracao.R
\encoding{UTF-8}
\name{epe4md_proj_geracao}
\alias{epe4md_proj_geracao}
\title{Estima a geração de eletricidade a partir da projeção de potência}
\usage{
epe4md_proj_geracao(
  proj_mensal,
  ano_base,
  filtro_de_uf,
  filtro_de_segmento,
  dir_dados_premissas = NA_character_
)
}
\arguments{
\item{proj_mensal}{dataframe. Resultado da função
\link{epe4md_proj_mensal}.}

\item{ano_base}{numeric. Ano base da projeção. Define o ano em que a função
irá buscar a base de dados. Último ano completo realizado.}

\item{filtro_de_uf}{string. Parâmetro que define uma unidade federativa (UF) a
ser filtrada. Caso uma UF não seja indicada ou seja informado um valor inválido,
o resultado será apresentado sem filtros.}

\item{filtro_de_segmento}{string. Parâmetro que define um segmento a ser
filtrado. Pode se escolher entre "comercial_at", "comercial_at_remoto",
"comercial_bt", "residencial" e "residencial_remoto".  Caso não seja
informado um valor ou seja informado um valor inválido o resultado será
apresentado sem filtro.}

\item{dir_dados_premissas}{Diretório onde se encontram as premissas.
Se esse parâmetro não for passado, a função usa os dados default que são
instalados com o pacote. É importante que os nomes dos arquivos sejam os
mesmos da pasta default.}
}
\value{
data.frame com os resultados da projeção de capacidade instalada
de micro e minigeração distribuída, número de adotantes e geração
mensal de energia.
}
\description{
Estima a geração de eletricidade a partir da projeção de potência
}
\examples{

projecao_mensal <- structure(
  list(ano = c(2018, 2019, 2020),
       nome_4md = c("COSERN", "EQUATORIAL AL", "ERO"),
       fonte_resumo = c("Fotovoltaica", "Fotovoltaica", "Fotovoltaica"),
       segmento = c("residencial", "comercial_bt", "residencial_remoto"),
       adotantes_mes = c(29, 38, 4),
       pot_mes_mw = c(0.16773, 0.42818, 0.01418),
       mes_ano = c("2018 jul 1", "2019 jun 1", "2020 ago 1"),
       mes = c(7, 6, 8),
       p = c(1e-04, 0.000321082460336051, 1e-04),
       q = c(0.999129117163193, 1, 0.788982959999952),
       Ft = c(0.0385425368844212, 0.260610809377481, 0.0652161787454779)),
  row.names = c(NA, -3L),
  class = c("tbl_df", "tbl", "data.frame")
)

projecao_mensal <- dplyr::mutate(projecao_mensal, mes_ano = strptime(mes_ano, "\%Y \%b \%d"))

proj_geracao <- epe4md_proj_geracao(
  proj_mensal = projecao_mensal,
  ano_base = 2021,
  filtro_de_uf = "N",
  filtro_de_segmento = "comercial_at",
  dir_dados_premissas = NA_character_
)
}

