% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GENESISClasses.R
\docType{class}
\name{RD1-class}
\alias{RD1-class}
\alias{header,RD1-method}
\alias{footer,RD1-method}
\alias{rd1,RD1-method}
\alias{rd1total,RD1-method}
\alias{content,RD1-method}
\alias{region,RD1-method}
\alias{protocol,RD1-method}
\alias{RegDeath1}
\alias{length,RD1-method}
\alias{show,RD1-method}
\alias{selectYears,RD1-method}
\alias{selectRegion,RD1-method}
\alias{readRegDeath}
\title{RD1 class for 'GENESIS-Tabelle: 12613-02-02-4'}
\usage{
\S4method{header}{RD1}(object)

\S4method{footer}{RD1}(object)

\S4method{rd1}{RD1}(object)

\S4method{rd1total}{RD1}(object)

\S4method{content}{RD1}(object)

\S4method{region}{RD1}(object)

\S4method{protocol}{RD1}(object)

RegDeath1(header, footer, rd1, rd1total, content, region, protocol)

\S4method{length}{RD1}(x)

\S4method{show}{RD1}(object)

\S4method{selectYears}{RD1}(object, selectYears)

\S4method{selectRegion}{RD1}(object, selectRegion)

readRegDeath(infile)
}
\arguments{
\item{object}{RD1-object}

\item{header}{vector}

\item{footer}{vector}

\item{rd1}{data.table}

\item{rd1total}{data.table}

\item{content}{character}

\item{region}{character}

\item{protocol}{character}

\item{x}{RD1-object}

\item{selectYears}{vector}

\item{selectRegion}{vector}

\item{infile}{character file name}
}
\value{
The \code{header}-method returns the raw header information

The \code{footer}-method returns the raw footer information

The \code{rd1}-method returns the death count table

The \code{rd1total}-method returns the death count total sums table

The \code{content}-method returns the content information

The \code{region}-method returns the regional information

The \code{protocol}-method returns the protocol information

The \code{RegDeath1}-constructor returns an RD1 object

The \code{length}-method returns the number of rows

The \code{selectYears}-method returns an RD1 object

The \code{selectRegion}-method returns an RD1 object

The \code{readRegDeath}-method returns an RD1 object
}
\description{
The class \code{RD1} stores GENESIS table information in a systematic way.

The \code{header}-method gets the raw header information of an RD1 object

The \code{footer}-method gets the raw footer information of an RD1 object

The \code{rd1}-method gets the death count table information of an RD1 object

The \code{rd1total}-method gets the death count total sums table information of an RD1 object

The \code{content}-method gets the death count table information of an RD1 object

The \code{region}-method gets the regional information of an RD1 object

The \code{protocol}-method gets the protocol information of an RD1 object

The \code{RegDeath1}-constructor creates an RD1 object

The \code{length}-method gets the number of rows int the RD1 rd1 data.table

The \code{selectYears}-method gets a subset of an RD1 object

The \code{selectRegion}-method gets a subset of an RD1 object

The \code{readRegDeath}-method reads all information from 'GENESIS-Tabelle: 12613-02-02-4'
}
\details{
This \code{RD1} class fits to the GENESIS table 12613-02-02-4.
See https://www.regionalstatistik.de/genesis/online for data details.
An RD1 instance stores the raw header, the raw footer, the content,
the version protocol and regional information and the
death count information as a data.table object. Further it stores a second data.table
with the total sums information.
Try demo(RD1) for a demonstration.
}
\section{Slots}{

\describe{
\item{\code{content}}{describes the content}

\item{\code{region}}{regional entity}

\item{\code{header}}{includes the raw header information}

\item{\code{footer}}{includes the raw footer information}

\item{\code{rd1}}{stores the death count table (data.table)}

\item{\code{rd1total}}{stores the death count total sums table (data.table)}

\item{\code{protocol}}{contains the protocol information}
}}

\examples{
d1 <- readRegDeath(file.path(system.file(package="eoR"), "extdata", "12613-02-02-4m.csv"))
header(d1)
footer(d1)
rd1(d1)[, table(Year)]
}
