% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init.R
\name{init}
\alias{init}
\title{Initialize the R environment with envsetup}
\usage{
init(project, config_path = NULL, create_paths = NULL)
}
\arguments{
\item{project}{Character. The path to the project directory.}

\item{config_path}{Character. The path of the config file. Defaults to NULL.}

\item{create_paths}{Logical indicating if missing paths should be created. Defaults to NULL.}
}
\value{
Called for its side-effects.
}
\description{
Initialize the R environment with envsetup
}
\examples{
tmpdir <- tempdir()
print(tmpdir)

# account for windows
if (Sys.info()['sysname'] == "Windows") {
  tmpdir <- gsub("\\\\", "\\\\\\\\", tmpdir, fixed = TRUE)
}

# Create an example config file\
hierarchy <- paste0("default:
  paths:
    data: !expr list(
      DEV = file.path('",tmpdir,"', 'demo', 'DEV', 'username', 'project1', 'data'),
      PROD = file.path('",tmpdir,"', 'demo', 'PROD', 'project1', 'data'))
    output: !expr list(
      DEV = file.path('",tmpdir,"', 'demo', 'DEV', 'username', 'project1', 'output'),
      PROD = file.path('",tmpdir,"', 'demo', 'PROD', 'project1', 'output'))
    programs: !expr list(
      DEV = file.path('",tmpdir,"', 'demo', 'DEV', 'username', 'project1', 'programs'),
      PROD = file.path('",tmpdir,"', 'demo', 'PROD', 'project1', 'programs'))")


writeLines(hierarchy, file.path(tmpdir, "hierarchy.yml"))

init(project = tmpdir,
     config_path = file.path(tmpdir, "hierarchy.yml"),
     create_paths = TRUE)
}
