% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extremevalue.R
\name{Moment.gpd.fit}
\alias{Moment.gpd.fit}
\title{Moment estimates of GP distribution parameters - Only intended for developer use}
\usage{
Moment.gpd.fit(x, k = round(length(x) * 0.1))
}
\arguments{
\item{x}{a numeric vector of observations.}

\item{k}{a positive integer giving the number of top rank statistics (de Haan and Ferreira, 2006). Default is \code{k = round(length(x) * 0.1)}.}
}
\value{
a numeric vector giving the moment estimates for the scale and shape parameters, resp.
a numeric vector giving the standard deviations for the scale and shape parameter estimates, resp.
}
\description{
Moment estimates of shape and scale parameters of GP distribution using the approach presented in (de Haan and Ferreira, 2006).
The function is called by \code{\link{KRDetect.outliers.EV}} and is not intended for use by regular users of the package.
}
\details{
This function computes the moment estimates of shape and scale parameters of GP distribution (de Haan and Ferreira, 2006).
The function is exported for developer use only. It does not perform any checks on inputs since it is only convenience function used within \code{\link{KRDetect.outliers.EV}}.
}
\references{
de Haan, L, Ferreira, A (2006). Extreme Value Theory: An Introduction. Springer.
}
