% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hl-dataframe.R
\name{hl}
\alias{hl}
\title{Highlight elements in a data.frame}
\usage{
hl(
  .data,
  palette,
  rows = NULL,
  cols = NULL,
  scale_apply,
  elem = "fill",
  show_legend = FALSE,
  opts = hl_opts()
)
}
\arguments{
\item{.data}{\code{emphatic} data.frame}

\item{palette}{colours to use for highlighting.  This may be a single R colour,
a vector of R colours, or
a \code{ggplot2} style "Scale" object e.g. \code{scale_colour_continuous()}.}

\item{rows, cols}{specification for rows and columns to target.  Default is NULL
for both rows and columns, which will target all columns/rows.
When \code{palette} argument is a \code{scale} object, then \code{cols}
indicates the columns which will be used to calculate the extents of
the scale.}

\item{scale_apply}{Only valid when palette is a \code{scale} object, specify
the target columns to colour. If missing (the default), this function
will only colour the column specified in the \code{cols} argument.
Use NULL to colour all columns.}

\item{elem}{Apply the highlighting to the 'fill' (the background) or the 'text'.
Default: 'fill'}

\item{show_legend}{if a scale object is used for colour, and \code{show_legend = TRUE},
then a colourbar legend will be added to the bottom of the output.
Default: FALSE}

\item{opts}{create options list}
}
\value{
An emphatic object suitable to output to console (for example)
}
\description{
Highlight elements in a data.frame by specifying rows and columns, and the
colour to be applied.  The colour can be either a vector of colours expressed
as characters (e.g. 'red', '#ff0000'), or a \code{ggplot2} Scale object
e.g. \code{scale_colour_viridis_c()}.
}
\section{Row and Column Specifications}{


Specifying rows and columns can be done in a number of ways.  These methods
are similar to the ideas of \code{tidyselect} and \code{dplyr} commands such
as \code{filter()} and \code{select()}

\describe{
\item{numeric vector}{row or column indices specified as a numeric vector
     e.g. \code{c(1, 2, 8)}}
\item{character vector}{vector of names matching row or column names
     e.g. \code{c('mpg', 'wt')}}
\item{vector of symbols/names}{vector of symbols which will be evaluated as
     column names e.g. \code{c(mpg, wt)}}
\item{numeric range}{range of indices specified using the \code{:} operator
     e.g. \code{1:8}}
\item{symbolic range}{range of columns specified using the \code{:} operator
     e.g. \code{mpg:wt}}
\item{tidyselect-style selectors}{\code{starts_with()}, \code{ends_with()},
     \code{everything()}, \code{all_of()}, \code{any_of()}, \code{matches()}
      \code{contains()}, \code{row_number()}, \code{n()}.
     These work similar to \code{dplyr} and \code{tidyselect} but are bespoke
     implementations so there may be some differences}
\item{NULL}{specifying \code{NULL} means that all rows/columns will be
     selected}
\item{all()}{specifying \code{all()} means that all rows/columns will be
     selected}
\item{code that will evaluate to row positions}{For \emph{row} selection only, the user
     can specify code which will evaluate to a logical vector of rows which
     the highlighting should apply to.  These will look like statements used
     in \code{dplyr::filter()}. E.g. \code{cyl == 6 & mpg > 20}}
}
}

\examples{
# Simple
mtcars |>
  head() |>
  hl(c('red', 'blue'))

# More involved example
mtcars |>
  head() |>
  hl(
    ggplot2::scale_colour_viridis_c(),
    rows = cyl == 6,
    cols = mpg,
    scale_apply = c(mpg, cyl)
  )
}
