% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-svg.R
\name{as_svg_group}
\alias{as_svg_group}
\title{Wrap an emphatic object to part of an SVG}
\usage{
as_svg_group(
  x,
  width = 1200,
  height = 900,
  font_size = NULL,
  style = list(),
  visible = TRUE,
  extra = NULL,
  ...
)
}
\arguments{
\item{x}{emphatic object}

\item{width, height}{viewBox dimensions for SVG}

\item{font_size}{CSS font-size. Default: NULL means to not adjust font size.
Otherwise, use valid CSS \code{font-size} specification e.g.
"3em", "22px" etc.}

\item{style}{html tag styling to apply to the \code{<pre>} wrapper for the
returned HTML}

\item{visible}{should the group be visible? Default: TRUE.  When animating,
every frame other than the first should be set as \code{visible = FALSE}.}

\item{extra}{extra tags to insert into group. default NULL}

\item{...}{other arguments passed to \code{as.character.emphatic()}}
}
\value{
Character string containing representation as an SVG group element
        i.e. \code{<g>}.  This result is suitable for combining with other
        SVG elements into a custom SVG document.
}
\description{
This function wraps \code{html} in SVG group tags (i.e. \code{<g>}).  This
may then be wrapped in \code{<svg>} tags to create a stand-along SVG.
}
\details{
This function is used internall by both \code{as_svg()} and \code{as_svg_anim()}
}
\examples{
hl_diff('hello', 'there') |>
  as_svg_group() |>
  cat()
}
