% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-html.R
\name{as_html}
\alias{as_html}
\title{Render an emphatic object to HTML}
\usage{
as_html(
  x,
  ...,
  font_size = NULL,
  style = list(),
  complete = FALSE,
  browsable = FALSE
)
}
\arguments{
\item{x}{emphatic object}

\item{...}{other arguments passed to \code{as.character.emphatic()}}

\item{font_size}{CSS font-size. Default: NULL means to not adjust font size.
Otherwise, use valid CSS \code{font-size} specification e.g.
"3em", "22px" etc.}

\item{style}{html tag styling to apply to the \code{<pre>} wrapper for the
returned HTML}

\item{complete}{logical. Default: FALSE.  If TRUE, then add DOCTYPE and
the tags for 'html', 'body' and 'head' to make a complete standalone
html file.}

\item{browsable}{Should the SVG be rendered to the RStudio Viewer pane when
when printed (instead of console output)? Default: FALSE}
}
\value{
Character string containing HTML representation
}
\description{
Render an emphatic object to HTML
}
\examples{
hl_diff('hello', 'there') |>
  as_html() |>
  cat()
}
