% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{p_value_csv_file}
\alias{p_value_csv_file}
\title{Used to add the p_value to each cocktail of a csv_file that is an
output of the genetic algorithm}
\usage{
p_value_csv_file(
  distribution_outputs,
  filename,
  filtred_distribution = FALSE,
  sep = ";"
)
}
\arguments{
\item{distribution_outputs}{A list of distribution of cocktails of different sizes
in order to compute the p_value for multiple cocktail sizes}

\item{filename}{The file name of the .csv file containing the output}

\item{filtred_distribution}{Does the p-values have to be computed using filtered distribution
or normal distribution (filtered distribution by default)}

\item{sep}{The separator used in the csv file (';' by default)}
}
\value{
A real valued number vector representing the p-value of the inputed
csv file filename, computed on the distribution_outputs List.
}
\description{
Used to add the p_value to each cocktail of a csv_file that is an
output of the genetic algorithm
}
\examples{
\donttest{
 data("ATC_Tree_UpperBound_2024")
 data("FAERS_myopathy")

  DistributionApproximationResults_size2 = DistributionApproximation(epochs = 10,
            ATCtree = ATC_Tree_UpperBound_2024, observations = FAERS_myopathy, Smax = 2)
            
  DistributionApproximationResults_size3 = DistributionApproximation(epochs = 10,
            ATCtree = ATC_Tree_UpperBound_2024, observations = FAERS_myopathy, Smax = 3)
            
  score_distribution_list = list(DistributionApproximationResults_size2,
                              DistributionApproximationResults_size3)
  p_value_csv_file(score_distribution_list, "path/to/output.csv")
}
}
