% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{GeneticAlgorithm}
\alias{GeneticAlgorithm}
\title{Genetic algorithm, trying to reach riskiest cocktails (the ones which maximize
the fitness function, Hypergeometric score in our case)}
\usage{
GeneticAlgorithm(
  epochs,
  nbIndividuals,
  ATCtree,
  observations,
  num_thread = 1L,
  diversity = FALSE,
  p_crossover = 0.8,
  p_mutation = 0.01,
  nbElite = 0L,
  tournamentSize = 2L,
  alpha = 1,
  summary = TRUE
)
}
\arguments{
\item{epochs}{: number of step or the algorithm}

\item{nbIndividuals}{: size of the population}

\item{ATCtree}{: ATC tree with upper bound of the DFS (without the root)}

\item{observations}{: real observation of the AE based on the medications of each patients
(a DataFrame containing the medication on the first column and the ADR (boolean) on the second)}

\item{num_thread}{: Number of thread to run in parallel if openMP is available, 1 by default}

\item{diversity}{: enable the diversity mechanism of the algorithm
(favor the diversity of cocktail in the population),  default is false}

\item{p_crossover}{: probability to operate a crossover on the crossover phase. Default is 80\%}

\item{p_mutation}{: probability to operate a mutation after the crossover phase. Default is 1\%}

\item{nbElite}{: number of best individual we keep from generation to generation. Default is 0}

\item{tournamentSize}{: size of the tournament (select the best individual 
between tournamentSize sampled individuals)}

\item{alpha}{: when making a type 1 mutation you have (alpha / size of cocktail) chance to add a drug.}

\item{summary}{: print the summary of population at each steps ?}
}
\value{
If no problem, return a List :
- meanFitnesses : The mean score of the population at each epochs of the algorithm.
- BestFitnesses : The best score of the population at each epochs of the algorithm.
- FinalPopulation : The final population of the algorithm when finished (medications
and corresponding scores)
}
\description{
Genetic algorithm, trying to reach riskiest cocktails (the ones which maximize
the fitness function, Hypergeometric score in our case)
}
\examples{
\donttest{
data("ATC_Tree_UpperBound_2024")
data("FAERS_myopathy")

results = GeneticAlgorithm(epochs = 10, nbIndividuals = 10, 
            ATCtree = ATC_Tree_UpperBound_2024,
            observations = FAERS_myopathy)
}
}
