% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/energy_ratios.R
\name{eroi_func}
\alias{eroi_func}
\title{Calculate Energy Return on Investment (EROI)}
\usage{
eroi_func(g, s, se = NULL)
}
\arguments{
\item{g}{Numeric vector of gross income values}

\item{s}{Numeric vector of energy spending values}

\item{se}{Optional numeric vector of effective energy spending (defaults to s)}
}
\value{
Numeric vector of EROI values
}
\description{
Calculates the Energy Return on Investment as the ratio of gross income to
effective energy spending. EROI = G/Se.
}
\examples{
# Calculate EROI for households
eroi_func(50000, 3000)
}
