% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/provider.R
\name{Provider}
\alias{Provider}
\title{A chatbot provider}
\usage{
Provider(
  name = stop("Required"),
  model = stop("Required"),
  base_url = stop("Required"),
  params = list(),
  extra_args = list(),
  extra_headers = character(0),
  credentials = function() NULL
)
}
\arguments{
\item{name}{Name of the provider.}

\item{model}{Name of the model.}

\item{base_url}{The base URL for the API.}

\item{params}{A list of standard parameters created by \code{\link[=params]{params()}}.}

\item{extra_args}{Arbitrary extra arguments to be included in the request body.}

\item{extra_headers}{Arbitrary extra headers to be added to the request.}

\item{credentials}{A zero-argument function that returns the credentials to use
for authentication. Can either return a string, representing an API key,
or a named list of headers.}
}
\value{
An S7 Provider object.
}
\description{
A Provider captures the details of one chatbot service/API. This captures
how the API works, not the details of the underlying large language model.
Different providers might offer the same (open source) model behind a
different API.
}
\details{
To add support for a new backend, you will need to subclass \code{Provider}
(adding any additional fields that your provider needs) and then implement
the various generics that control the behavior of each provider.
}
\examples{
Provider(
  name = "CoolModels",
  model = "my_model",
  base_url = "https://cool-models.com"
)
}
