% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpv_coef_plot.R
\name{rpv_coef_plot}
\alias{rpv_coef_plot}
\title{Racially Polarized Voting Analysis (RPV) Coefficient Plot}
\usage{
rpv_coef_plot(
  rpvDF = NULL,
  title = "Racially Polarized Voting Analysis Estimates",
  caption = "Data: eiCompare RPV estimates",
  ylab = NULL,
  colors = NULL,
  race_order = NULL
)
}
\arguments{
\item{rpvDF}{A data.frame containing RPV results}

\item{title}{The plot title}

\item{caption}{The plot caption}

\item{ylab}{Label along y axis}

\item{colors}{Character vector of colors, one for each racial group. The order 
of colors will be respective to the order of racial groups.}

\item{race_order}{Character vector of racial groups from the \code{voter_race} column of
\code{rpvDF} in the order they should appear in the plot. If not specified, 
the race groups will appear in alphabetical order.}
}
\value{
Coefficient plot of RPV analysis as a ggplot2 object
}
\description{
Creates a coefficient plot showing of RPV results estimate ranges
of all contests by voter race
}
\examples{
library(eiExpand)
data(example_rpvDF)

dem_rpv_results <- example_rpvDF \%>\% dplyr::filter(Party == "Democratic")
rpv_coef_plot(dem_rpv_results)
}
\author{
Rachel Carroll <rachelcarroll4@gmail.com>

Stephen El-Khatib <stevekhatib@gmail.com>

Loren Collingwood <lcollingwood@unm.edu>
}
