% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ge2.R
\name{ege2}
\alias{ege2}
\title{Generalized entropy measure of education}
\usage{
ege2(countries, init.y, final.y, database, plot = TRUE)
}
\arguments{
\item{countries}{character vector with the country codes of the countries
to be used. Some macro-regions are already defined and can be used
instead of the country codes: \code{South Asia, Europe and Central Asia,
Middle East and North Africa, Latin America and the Caribbean, Advanced
Economies, Sub-Saharan Africa, East Asia and the Pacific} and \code{all}
for the 142 counrties included in the dataset.(see \code{data_country}).}

\item{init.y}{the first year in which the function is calculated. Available
years are 1970, 1975, 1980, 1985, 1990, 1995, 2000, 2005, 2010.}

\item{final.y}{the last year in which the function is calculated Available
years are 1970, 1975, 1980, 1985, 1990, 1995, 2000, 2005, 2010.}

\item{database}{population subgrup for which the function is calculated.
The following options are available:
\enumerate{
  \item \code{"total15"}: Total population aged over-15.
  \item \code{"total25"}: Total population aged over-25.
  \item \code{"male15"}: Male population aged over-15.
  \item \code{"male25"}: Male population aged over-25.
  \item \code{"female15"}: Female population aged over-15.
  \item \code{"female25"}: Female population aged over-25.
}}

\item{plot}{if \code{TRUE} (the default), displays a graph of the results.}
}
\value{
\code{ege2} returns a list with the following objects:
  \enumerate{
  \item \code{GE_2}: evolution of the generalized entropy measure of education
    from the initial to the last year, decomposed in between-country
    and within-country inequality.
  \item \code{countries}: countries used to compute the generalized entropy measure.
  \item If \code{plot = TRUE}, graphical representation of the numerical results.
  }
}
\description{
\code{ege2} function computes the generalized entropy measure of education, with
the sensitivity parameter set to 2, for any group of countries included
in the dataset developed in Jorda and Alonso (2017). The function also
provides a decomposition of this index in between-county and within-
country inequality.
}
\details{
The estimates of the generalized entropy measure for the specified group of countries
can be easily derived by taking advantage of the decomposition of this family.
It is computed as the sum of the following terms, which correspond to within-
country and between, country inequality respectively (see, e.g., Cowell, 2011):

\eqn{GE(2)_W=\sum_{i=1}^{N} s_i^2 p_i^{-1} GE(2)_i;}

\eqn{GE(2)_B= 0.5 \sum_{i=1}^{N} p_i (\mu_i / \mu)^2 -1,}

where \emph{N} is the number of countries, \eqn{GE(2)_i} and \eqn{p_i} denote,
respectively, the generalized entropy measure and the population weight of the
country \emph{i}, and \eqn{s_i} stands for the proportion of mean income of the
country \emph{i} in the overall mean of the group:
\eqn{s_i=\lambda_i \mu_i / \sum_{i=1}^{N} \lambda_i \mu_i}.
}
\examples{
ege2(countries = "all", init.y = 1980, final.y = 2000,
     database = "total25")
ege2(countries = c("DNK", "FIN", "ISL", "NOR", "SWE"), init.y = 1980,
     final.y = 2000, database = "female15")
}
\references{
Cowell, F. (2011). Measuring inequality. Oxford University Press.

Jorda, V. and Alonso, J.M. (2017). New estimates on educational
 attainment using a continuous approach (1970-2010), World Development,
 90, 281 - 293.
 \url{http://www.sciencedirect.com/science/article/pii/S0305750X16305010}
}
\seealso{
\code{\link{data_country}}. Visit \url{http://www.educationdata.unican.es}
  for more information on the constructoin of the dataset and the available
  \href{http://www.educationdata.unican.es/countries}{countries}.
}

