% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/editableDT.R
\name{editableDTUI}
\alias{editableDTUI}
\title{UI of editableDT Shiny module}
\usage{
editableDTUI(id)
}
\arguments{
\item{id}{A string}
}
\description{
UI of editableDT Shiny module
}
\examples{
# Only run examples in interactive R sessions
if (interactive()) {
library(shiny)
ui=fluidPage(
  selectInput("select","select",choices=c("mtcars","iris","sampleData")),
  textInput("mydata","mydata",value="mtcars"),
  hr(),
  editableDTUI("editableDT"),
  hr(),
  verbatimTextOutput("test")
)
server=function(input,output,session){
  data=reactive({
            myget(input$mydata)
  })
  observeEvent(input$select,{
       updateTextInput(session,"mydata",value=input$select)
  })
  result=callModule(editableDT,"editableDT",data=data)
  output$test=renderPrint({
  str(result())
  })
}
shinyApp(ui=ui,server=server)
}
}
