% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/child_coefs.R
\docType{data}
\name{child_hcc}
\alias{child_hcc}
\title{Child HCC Factors - Table 9}
\format{
An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with
128 rows and 7 columns
\describe{
\item{used}{Whether or not the category is used in the RA model}
\item{plat, gold, silver, bronze, cat}{HCC grouping risk score for each
metal level}
\item{hcc}{HCC label for risk scores (Includes leading zeroes)}
}
}
\source{
Data import and cleaning at:
\url{https://github.com/EeethB/edgedata/tree/main/data-raw}
}
\usage{
child_hcc
}
\description{
A dataset containing the child model HCC factors for the risk adjustment
model. Condition categories (CCs) are triggered by ICD-10 codes (See
\code{\link{icd_cc}}), and a hierarchy is then applied (See
\code{\link{cc_hier}}), creating hierarchical condition categories (HCCs).
}
\seealso{
Other factors: 
\code{\link{adult_demo}},
\code{\link{adult_enroll_dur}},
\code{\link{adult_group}},
\code{\link{adult_hcc}},
\code{\link{adult_interaction}},
\code{\link{adult_rxc_hcc_inter}},
\code{\link{adult_rxc}},
\code{\link{child_demo}},
\code{\link{child_group}},
\code{\link{infant_demo}},
\code{\link{infant_mat_sev}}

Other HCC tables: 
\code{\link{adult_group}},
\code{\link{adult_hcc}},
\code{\link{adult_interaction}},
\code{\link{adult_rxc_hcc_inter}},
\code{\link{cc_hier}},
\code{\link{child_group}},
\code{\link{cpt_hcpcs}},
\code{\link{icd_cc}}
}
\concept{HCC tables}
\concept{factors}
\keyword{datasets}
