% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/func_gg.R
\name{ggxy}
\alias{ggxy}
\title{XY scatter plot wrapper}
\usage{
ggxy(
  d,
  x,
  y,
  ...,
  lm = TRUE,
  se = TRUE,
  cor = TRUE,
  pv = NULL,
  nsub = TRUE,
  legend = TRUE,
  asp = 1
)
}
\arguments{
\item{d}{\verb{<dfr>} A data frame.}

\item{x, y}{\verb{<var>} Variables for x- and y-axis as unquoted names.}

\item{...}{Arguments to pass to \link[ggplot2:aes]{ggplot2::aes} for additional mapping.}

\item{lm}{\verb{<lgl>} \code{TRUE} to add regression line from linear model.}

\item{se}{\verb{<lgl>} \code{TRUE} to show standard error with the regression line.}

\item{cor}{\verb{<lgl>} \code{TRUE} to show Pearson correlation coefficient with p-value.}

\item{pv}{\verb{<dbl>} Precision for the p-value, e.g., 0.001 to show 3 decimal places.}

\item{nsub}{\verb{<lgl>} Show number of observations.}

\item{legend}{\verb{<lgl>} \code{TRUE} to show legend.}

\item{asp}{\verb{<num>} For \code{aspect.ratio} in \link[ggplot2:theme]{ggplot2::theme}.}
}
\value{
A ggplot object.
}
\description{
Create basic XY scatter plot for quick data exploration.
Default to show Pearson correlation coefficient with p-value using \link[ggpubr:stat_cor]{ggpubr::stat_cor}.
For more complex plots, it is recommended to use \link[ggplot2:ggplot2-package]{ggplot2::ggplot2} directly.
}
\examples{
mtcars |> ggxy(wt,hp)
mtcars |> ggxy(wt,hp,col=factor(gear))
mtcars |> ggxy(wt,hp,col=factor(gear),legend=FALSE)
mtcars |> ggxy(wt,hp,col=factor(gear),pch=factor(am))
mtcars |> ggxy(wt,hp,nsub=FALSE)
mtcars |> ggxy(wt,hp,pv=0.001)
mtcars |> ggxy(wt,hp,lm=FALSE)
mtcars |> ggxy(wt,hp,se=FALSE)
mtcars |> ggxy(wt,hp,cor=FALSE)
}
\seealso{
\link[ggpubr:stat_cor]{ggpubr::stat_cor}
}
