% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operator.mutator.polynomial.R
\name{mutPolynomial}
\alias{mutPolynomial}
\title{Polynomial mutation.}
\usage{
mutPolynomial(ind, p = 0.2, eta = 10, lower, upper)
}
\arguments{
\item{ind}{[\code{numeric}]\cr
Numeric vector / individual to mutate.}

\item{p}{[\code{numeric(1)}]\cr
Probability of mutation for each gene of an offspring. In other words, 
the probability that the value (allele) of a given gene will change.
Default is 0.2}

\item{eta}{[\code{numeric(1)}\cr
Distance parameter to control the shape of the mutation distribution. 
Larger values generate offspring closer to the parents.
Default is 10.}

\item{lower}{[\code{numeric}]\cr
Vector of minimal values for each parameter of the decision space.
Must have the same length as \code{ind}.}

\item{upper}{[\code{numeric}]\cr
Vector of maximal values for each parameter of the decision space.
Must have the same length as \code{ind}.}
}
\value{
[\code{numeric}]
}
\description{
Performs an polynomial mutation as used in the SMS-EMOA algorithm.
Polynomial mutation tries to simulate the distribution of the offspring of 
binary-encoded bit flip mutations based on real-valued decision variables. 
Polynomial mutation favors offspring nearer to the parent.
}
\references{
[1] Deb, Kalyanmoy & Goyal, Mayank. (1999). A Combined Genetic Adaptive 
Search (GeneAS) for Engineering Design. Computer Science and Informatics. 26.
Retrieved from http://citeseerx.ist.psu.edu/viewdoc/download?doi=10.1.1.27.767&rep=rep1&type=pdf
}
\seealso{
Other mutators: 
\code{\link{mutBitflip}()},
\code{\link{mutGauss}()},
\code{\link{mutInsertion}()},
\code{\link{mutInversion}()},
\code{\link{mutJump}()},
\code{\link{mutScramble}()},
\code{\link{mutSwap}()},
\code{\link{mutUniform}()}
}
\concept{mutators}
