% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pecp.R
\name{pecp}
\alias{pecp}
\title{Distribution function}
\usage{
pecp(q, lambda, gamma, phi, lower_tail = TRUE, log_p = FALSE)
}
\arguments{
\item{q}{vector of quantiles.}

\item{lambda, gamma}{parameter values > 0.}

\item{phi}{parameter value != 0.}

\item{lower_tail}{similar to lower.tail}

\item{log_p}{logical value}
}
\value{
Numeric value of the distribution function.

If lower_tail = FALSE, numeric value of the survival function.

If log_p = TRUE, numeric value of the logarithm of the function.
}
\description{
Compute the cumulative distribution function of the extended
Chen-Poisson (ecp) distribution.
}
\examples{
pecp(2, 1, 1, 1, lower_tail = TRUE, log_p = FALSE) # distribution function
pecp(2, 1, 1, 1, lower_tail = FALSE, log_p = FALSE) # survival function

}
