% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_sensitivity.R
\name{calc_sensitivity}
\alias{calc_sensitivity}
\title{Calculate Overall Sensitivity and Adaptive Capacity Scores from Trait-Specific Expert Ratings}
\usage{
calc_sensitivity(
  indicators,
  pressures,
  type = "direct",
  sensitivity_traits,
  adaptive_capacities = NULL,
  uncertainty_sens = NULL,
  uncertainty_ac = NULL,
  method = "mean"
)
}
\arguments{
\item{indicators}{A character vector or column of a data frame containing the
names of the state indicators.}

\item{pressures}{A character vector or column of a data frame containing
the names of the pressures.}

\item{type}{A character vector or column of a data frame specifying the effect type.
Effects could be direct or indirect or a combination of both. Default is
\code{direct}.}

\item{sensitivity_traits}{A data frame containing the numeric sensitivity
values per species trait or as a general value.}

\item{adaptive_capacities}{A data frame (or single vector) containing the
numeric values for the adaptive capacity. Either per trait or as one
general value. When values are given per trait, they have to be in the
same order as the values for the sensitivity. The default is \code{NULL}.}

\item{uncertainty_sens}{A data frame (or a vector) containing the numeric uncertainty
values associated with the sensitivity; default is \code{NULL}.}

\item{uncertainty_ac}{A data frame (or a vector) containing the numeric uncertainty
values associated with the adaptive capacity; default is \code{NULL}.}

\item{method}{A character string specifying the method of the aggregation of the traits.
Available are \code{median}, \code{minimum}, \code{maximum} and \code{mean},
the \code{mean} is default.}
}
\value{
a data frame containing the indicator, pressure and effect type,
the aggregated sensitivity and adaptive capacity as well as their associated uncertainty scores.
Additionally, the trait specific sensitivity and adaptive capacity scores are stored and used later
as input for the \code{vulnerability} function.
}
\description{
The function \code{calc_sensitivity} calculates aggregated sensitivity and adaptive
capacity scores. Additionally it prepares the scoring data for the further
usage in the \code{vulnerability} function. The scores for sensitivity and
adaptive capacity can be trait-based or general (one score per state indicator
and pressure combination).
}
\details{
The function calculates per state indicator and
pressure combination one aggregated sensitivity and adaptive capacity score,
the aggregation method can be determined with the parameter \code{method}.
The assessment of adaptive capacity is optionally, if no scores for adaptive
capacity are provided the function calculates an aggregated sensitivity score
and prepares only the sensitivity scores for the \code{\link{vulnerability}} function.
Guidance for the scoring process can be found here: \code{\link{create_template_sensitivity}}
or in the vignette or in Gutte et al., 2025.
Using exposure and sensitivity scorings, vulnerability is calculated.
}
\examples{
### Example using demo data with four indicators and five pressures with
#   scores for direct as well as combined direct-indirect effects based on
#   the template function create_template_sensitivity(). For two
#   indicators, sensitivity, adaptive capacity, and their uncertainties are
#   provided as general scores, while for the other two, they are based on
#   individual traits.
ex_expert_sensitivity

# Calculate only mean sensitivity scores:
calc_sensitivity(
  indicators = ex_expert_sensitivity$indicator,
  pressures = ex_expert_sensitivity$pressure,
  sensitivity_traits = ex_expert_sensitivity[ ,4:8],
  adaptive_capacities = NULL,   # (default)
  uncertainty_sens  = NULL,     # (default)
  uncertainty_ac = NULL,        # (default)
  method = "mean"               # (default)
 )

# Calculate mean scores for sensitivity, adaptive capacity and
# associated uncertainties:
calc_sensitivity(
  indicators = ex_expert_sensitivity$indicator,
  pressures = ex_expert_sensitivity$pressure,
  type = ex_expert_sensitivity$type,
  sensitivity_traits = ex_expert_sensitivity[ ,4:8],
  adaptive_capacities = ex_expert_sensitivity[ ,9:13],
  uncertainty_sens  = ex_expert_sensitivity[ ,14:18],
  uncertainty_ac = ex_expert_sensitivity[ ,19:23]
 )


### Example for one indicator and three pressures to evaluate direct
#   effects where sensitivity is scored for four individual traits:
ind <- "herring"
press <- c("fishing", "temperature increase", "salinity decrease")

# Create scoring table using the template function:
sens_ac_tbl <- create_template_sensitivity(
  indicators = ind,
  pressures = press,
  type = "direct",                      # (default)
  n_sensitivity_traits = 4,
  adaptive_capacity = TRUE,             # (default)
  mode_adaptive_capacity = "general",   # (default)
  uncertainty = TRUE,                   # (default)
  mode_uncertainty = "general"          # (default)
)

# Rename trait columns:
trait_cols <- paste0("sens_",
  c("feeding", "behaviour", "reproduction", "habitat"))
names(sens_ac_tbl)[4:7] <- trait_cols
# Give trait-specific sensitivity scores:
sens_ac_tbl$sens_feeding <- c(0,0,0)
sens_ac_tbl$sens_behaviour <- c(-1,0,-4)
sens_ac_tbl$sens_reproduction <- c(-2,-2,-5)
sens_ac_tbl$sens_habitat <- c(-3,-2,0)

# Give general adaptive capacity and uncertainty scores:
sens_ac_tbl$ac_general <- c(0,0,-1)
sens_ac_tbl$uncertainty_sens <- c(1,1,1)
sens_ac_tbl$uncertainty_ac <- c(1,1,2)

sens_ac_tbl

# Calculate median sensitivity scores (adaptive capacities and
# uncertainties cannot be aggregated further):
calc_sensitivity(
  indicators = sens_ac_tbl$indicator,
  pressures = sens_ac_tbl$pressure,
  sensitivity_traits = sens_ac_tbl[, trait_cols],
  adaptive_capacities = sens_ac_tbl$ac_general,
  uncertainty_sens  = sens_ac_tbl$uncertainty_sens,
  uncertainty_ac = sens_ac_tbl$uncertainty_ac,
  method = "median"
)
}
\seealso{
\code{\link{create_template_exposure}}, \code{\link{create_template_sensitivity}},
\code{\link{calc_exposure}}, \code{\link{vulnerability}}
}
