% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecmpredict.r
\name{ecmpredict}
\alias{ecmpredict}
\title{Predict using an ecm object}
\usage{
ecmpredict(model, newdata, init)
}
\arguments{
\item{model}{ecm object used to make predictions}

\item{newdata}{Data frame to on which to predict}

\item{init}{Initial value(s) for prediction}
}
\value{
Numeric predictions on new data based ecm object
}
\description{
Takes an ecm object and uses it to predict based on new data. This prediction does the undifferencing required to transform the change in y back to y itself.
}
\details{
Since error correction models only model the change in the target variable, an initial value must be specified. Additionally, the 'newdata' parameter should have at least 3 rows of data.
}
\examples{
##Not run

data(Wilshire)

#Rebuilding model1 from ecm example
trn <- Wilshire[Wilshire$date<='2015-12-01',]
xeq <- xtr <- trn[c('CorpProfits', 'FedFundsRate', 'UnempRate')]
model1 <- ecm(trn$Wilshire5000, xeq, xtr)
model2 <- ecm(trn$Wilshire5000, xeq, xtr, linearFitter='earth')

#Use 2015-12-01 and onwards data as test data to predict
tst <- Wilshire[Wilshire$date>='2015-12-01',]

#predict on tst using model1 and initial FedFundsRate
tst$model1Pred <- ecmpredict(model1, tst, tst$Wilshire5000[1])
tst$model2Pred <- ecmpredict(model2, tst, tst$Wilshire5000[1])

}
