% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid_selection.R
\name{ebnm_scale_normalmix}
\alias{ebnm_scale_normalmix}
\title{Set scale parameter for scale mixtures of normals}
\usage{
ebnm_scale_normalmix(
  x,
  s,
  mode = 0,
  min_K = 3,
  max_K = 300,
  KLdiv_target = 1/length(x)
)
}
\arguments{
\item{x}{A vector of observations. Missing observations (\code{NA}s) are
not allowed.}

\item{s}{A vector of standard errors (or a scalar if all are equal).
Standard errors may not be exactly zero, and missing standard errors are
not allowed.}

\item{mode}{A scalar specifying the mode of the prior \eqn{g}.}

\item{min_K}{The minimum number of components \eqn{K} to include in the
finite mixture of normal distributions used to approximate the
nonparametric family of scale mixtures of normals.}

\item{max_K}{The maximum number of components \eqn{K} to include in the
approximating mixture of normal distributions.}

\item{KLdiv_target}{The desired bound \eqn{\kappa} on the KL-divergence from
the solution obtained using the approximating mixture to the exact
solution. More precisely, the scale parameter is set such that given
the exact MLE
\deqn{\hat{g} := \mathrm{argmax}_{g \in G} L(g),}
where \eqn{G} is the full nonparametric family, and given the MLE for the
approximating family \eqn{\tilde{G}}
\deqn{\tilde{g} := \mathrm{argmax}_{g \in \tilde{G}} L(g),}
we have that
\deqn{\mathrm{KL}(\hat{g} \ast N(0, s^2) \mid \tilde{g} \ast N(0, s^2)) \le \kappa,}
where \eqn{\ast \ N(0, s^2)} denotes convolution with the normal error
distribution (the derivation of the bound assumes homoskedastic
observations). For details, see \strong{References} below.}
}
\description{
The default method for setting the \code{scale} parameter for function
  \code{\link{ebnm_normal_scale_mixture}}.
}
\references{
Jason Willwerscheid (2021).
  \emph{Empirical Bayes Matrix Factorization: Methods and Applications}.
  University of Chicago, PhD dissertation.
}
