% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epm_all_fx.R
\name{EPM_prep_outfile}
\alias{EPM_prep_outfile}
\title{Map Job Batches to Filenames.}
\usage{
EPM_prep_outfile(job_list, path, prefix)
}
\arguments{
\item{job_list}{data.frame. This is the `job_list` data.frame included in 
the `misc` slot of an `easyPubMed` object.}

\item{path}{folder on the local computer where files will be saved. It must 
be an existing directory.}

\item{prefix}{string used as common prefix for all files written as part of 
the same PubMed record download job.}
}
\value{
character vector pointing to the target files where Pubmed
records will be written.
}
\description{
Build Filenames Matching job sub-tasks. Each filename corresponds to
a series of records returned by a specific job batch. The associated
filename indicates where the corresponding records will be written 
on the local disc (if requested by the user).
}
\examples{
test_df <- data.frame(query_string = c('ANY', 'ANY'), 
                      init_date = c('2020/01/01', '2020/01/10'), 
                      end_date = c('2020/01/11', '2020/01/20'), 
                      diff_days = c(10, 10), 
                      exp_count = 100, 100)
easyPubMed:::EPM_prep_outfile(test_df, path = '.', prefix = 'my_test_job')                   


}
\references{
\url{https://www.data-pulse.com/dev_site/easypubmed/}
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
\keyword{internal}
