% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.earlyR.R
\name{plot.earlyR}
\alias{plot.earlyR}
\alias{points.earlyR}
\title{Plot earlyR objects}
\usage{
\method{plot}{earlyR}(x, type = c("R", "lambdas"), scale = "ml", ...)

\method{points}{earlyR}(x, scale = 1, ...)
}
\arguments{
\item{x}{A \code{earlyR} object.}

\item{type}{The type of graphic to be generated, matching either "R" or
"lamdbas"; "R" will plot the likelihood of R values; "lambdas" will plot
the force of infection over time; see `scale` argument to interprete the
force of infection.}

\item{scale}{A numeric value indicating the total number of new cases
expected over the time period of the lambdas, or a recognised `character`
string; lambdas will be scaled to correspond to the number of expected
cases every day; defaults to `ml`, which tells function to use the maximum
likelihood estimate of *R* multiplied by the number of infectious cases}

\item{...}{Further arguments to be passed to other methods; for the plot of
*R*, `...` is passed to `ggplot2::geom_line()`; for the plot of *lambdas*,
`...` is passed to `ggplot2::geom_bar()`.}
}
\value{
A `ggplot2` object.


if (require(incidence)) {

## example: onsets on days 1, 5, 6 and 12; estimation on day 24
onset <- c(1, 5, 6, 12)
x <- incidence(onset, last_date = 24)
x

res <- get_R(x, disease = "ebola")
res
plot(res)
plot(res, "lambdas")

}
}
\description{
These functions are designed for plotting \code{earlyR} objects, output by
the function \code{\link{get_R}}. It can plot either the likelihood of R
values, or the force of infection over time (see argument \code{type}). For
\code{points}, the latter is used.
}
\author{
Thibaut Jombart \email{thibautjombart@gmail.com}
}
