% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semantic_enrich.R
\name{edge_tbl_to_graph}
\alias{edge_tbl_to_graph}
\title{Convert edge table to tidygraph graph}
\usage{
edge_tbl_to_graph(edge_tbl)
}
\arguments{
\item{edge_tbl}{data frame containing 'from' nodes in column 1 and 'to' nodes
in column 2 so that all nodes go 'towards' the root node}
}
\value{
\code{\link[tidygraph:tidygraph]{tidygraph}} representation of the edge table
}
\description{
A edge table, as a data frame, is converted to a directed tidygraph
\code{\link[tidygraph:tidygraph]{tidygraph}}. Column 1 of the edge table is
interpreted as a "from" column, Column 2 is interpreted as a "to" column, and
any further columns are interpreted as attributes of the entity/node recorded
in column 1. Incomplete cases are removed from the edge table (rows) to avoid
redundancy
}
\examples{
# basic edge table
edge_tbl <- tibble::tribble(~from, ~to,
"Nstage", "TNM",
"Tstage", "TNM",
"Tumoursize", "property_of_tumour",
"Tstage", "property_of_tumour",
"property_of_tumour", "property_of_cancer",
"TNM", "property_of_cancer",
"property_of_cancer", "disease",
"disease", "root",
"root", NA)

graph <- edge_tbl_to_graph(edge_tbl)

graph

plot(graph)


# edge table with node attributes
## note that root node is included in final row to include its label
edge_tbl <- tibble::tribble(~from, ~to, ~label,
"Nstage", "TNM", "N stage",
"Tstage", "TNM", "T stage",
"Tumoursize", "property_of_tumour", "Tumour size",
"Tstage", "property_of_tumour", "T stage",
"property_of_tumour", "property_of_cancer", "Property of tumour",
"TNM", "property_of_cancer", "TNM",
"property_of_cancer", "disease", "Property of cancer",
"disease", "root", "Disease",
"root", NA, "Ontology Root")
graph <- edge_tbl_to_graph(edge_tbl)

graph

plot(graph)

}
