% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fred_series.R
\name{fred_series}
\alias{fred_series}
\alias{fred_series_release}
\alias{fred_series_categories}
\alias{fred_series_tags}
\alias{fred_observations}
\alias{fred_series_vintage}
\title{Fetch Data or Information on a SERIES in FRED}
\usage{
fred_series(..., key = NULL, realtime_start = NULL, realtime_end = NULL)

fred_series_release(
  ...,
  key = NULL,
  realtime_start = NULL,
  realtime_end = NULL
)

fred_series_categories(
  ...,
  key = NULL,
  realtime_start = NULL,
  realtime_end = NULL
)

fred_series_tags(..., key = NULL, realtime_start = NULL, realtime_end = NULL)

fred_observations(
  ...,
  key = NULL,
  realtime_start = NULL,
  realtime_end = NULL,
  all = TRUE
)

fred_series_vintage(
  ...,
  key = NULL,
  realtime_start = NULL,
  realtime_end = NULL
)
}
\arguments{
\item{...}{character vectors of series to fetch. If named, then the names are used to identify the series in the result.}

\item{key}{32 character lower-cased alpha-numeric character string}

\item{realtime_start, realtime_end}{character date strings of format "YYY-MM-DD" used obtain information that was known during the specified time period. If empty, the latest update of the information is used.}

\item{all}{logical; should all observations be used? Defaults to \code{TRUE}. If \code{FALSE}, only observations existing in all series will be kept.}
}
\value{
data.frame or list
}
\description{
Each of the functions accept a series ID from FRED and return a data.frame with information about the series.
}
\details{
Each function returns the following information in a data.frame.

\describe{
 \item{\code{fred_observations}}{Date of observation, its value, and the realtime start and end dates}
 \item{\code{fred_series}}{Series id, its title, observations start and end, frequency, units, seasonal adjustment type, popularity, realtime start and end, and when it was last updated}
 \item{\code{fred_series_categories}}{Category id, its name, and the id of its parent}
 \item{\code{fred_series_release}}{Release id, its name, a url link, whether there is a press release, and realtime start and end dates}
 \item{\code{fred_series_tags}}{Tag name, its group id, popularity, the number of series that are tagged, when it was created, and any notes about the tag}
 \item{\code{fred_series_related_tags}}{Same as \code{fred_series_tags}}
 \item{\code{fred_series_vintage}}{dates of each vintage}


 \item{\code{fred_category_related_tags}}{Same as \code{fred_category_tags}}
}
}
\section{Functions}{
\itemize{
\item \code{fred_series}: get information about the series including observation periods, seasonal adjustment, units, title, etc.

\item \code{fred_series_release}: get the release information about the series

\item \code{fred_series_categories}: get the categories into which a series falls

\item \code{fred_series_tags}: get the FRED tags for the series

\item \code{fred_observations}: get the observational data for a series

\item \code{fred_series_vintage}: get the dates in which the data for the series were revised or released. Returns a named list of dates.
}}

