% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chi.R
\name{chi}
\alias{chi}
\alias{chi.fcm}
\alias{Echi}
\title{Tail Dependence Coefficient (Chi Statistic)}
\usage{
\method{chi}{fcm}(object, h, u = 0.95, ...)

Echi(object, which = c(1, 2), u = 0.95)
}
\arguments{
\item{object}{an object of class \code{"fcm"}, created by \code{\link[=fcm]{fcm()}}.}

\item{h}{a positive numeric value representing the spatial distance (in kilometers).}

\item{u}{a numeric value between 0 and 1 specifying the quantile threshold. Default is 0.95.}

\item{...}{currently ignored.}

\item{which}{A length-two integer vector giving the indices of the
columns in \code{object$data} to be used for the empirical
chi calculation.}
}
\value{
A named numeric value, the chi statistic for given \code{h} and \code{u}.
}
\description{
Compute the conditional exceedance probability \eqn{\chi_h(u)},
either from a fitted eFCM model (\code{\link{chi.fcm}}) or empirically (\code{\link{Echi}}).
\eqn{\chi_h(u)} measures the probability of simultaneous exceedances at high but finite thresholds.
}
\details{
For two locations \eqn{s_1} and \eqn{s_2} separated by distance \eqn{h},
with respective vector components \eqn{W(s_1)} and \eqn{W(s_2)},
the conditional exceedance probability is defined as
\deqn{ \chi_h(u) \;=\; \lim_{u \to 1} \Pr\!\big( F_{s_1}(W(s_1)) > u \;\mid\; F_{s_2}(W(s_2)) > u \big). }
For the eFCM, the conditional exceedance probability \eqn{\chi_{\mathrm{eFCM}}(u)}
can be computed as
\deqn{
\chi_{\mathrm{eFCM}}(u) =
\frac{1 - 2u + \Phi_2\big(z(u), z(u); \rho\big)
- 2 \exp\!\left( \frac{\lambda^2}{2} - \lambda\, z(u)\, \Phi_2\big(q; 0, \Omega\big) \right)}
{1 - u}.
}
Here, \eqn{z(u) = F_1^{-1}(u; \lambda)} is the marginal quantile function,
\eqn{\Phi_2(\cdot,\cdot;\rho)} denotes the bivariate standard normal CDF with correlation \eqn{\rho},
\eqn{q = \lambda(1-\rho)}, and \eqn{\Omega} is the correlation matrix.
}
\section{Methods}{

\itemize{
\item \code{chi.fcm()}: Model-based estimate from an object of class \code{"fcm"}.
\item \code{Echi()}: Empirical estimate.
}
}

\examples{
\donttest{
fit <- fcm(...)
chi(fit, h = 150, u = 0.95)
}

}
\references{
Castro-Camilo, D. and Huser, R. (2020).
Local likelihood estimation of complex tail dependence structures,
applied to US precipitation extremes.
\emph{Journal of the American Statistical Association}, 115(531), 1037–1054.
}
