% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/5_gold_standard.R
\name{generate_gold_standard}
\alias{generate_gold_standard}
\alias{gold_standard_default}
\title{Simulate the gold standard}
\usage{
generate_gold_standard(model)

gold_standard_default(
  tau = 30/3600,
  census_interval = 10/60,
  simulate_targets = FALSE
)
}
\arguments{
\item{model}{A dyngen intermediary model for which the kinetics of the feature network has been generated with \code{\link[=generate_kinetics]{generate_kinetics()}}.}

\item{tau}{The time step of the ODE algorithm used to generate the gold standard.}

\item{census_interval}{A granularity parameter of the gold standard time steps. Should be larger than or equal to \code{tau}.}

\item{simulate_targets}{Also simulate the targets during the gold standard simulation}
}
\value{
A dyngen model.
}
\description{
\code{\link[=generate_gold_standard]{generate_gold_standard()}} runs simulations in order to determine the gold standard
of the simulations.
\code{\link[=gold_standard_default]{gold_standard_default()}} is used to configure parameters pertaining this process.
}
\examples{
model <- 
  initialise_model(
    backbone = backbone_bifurcating(),
    gold_standard = gold_standard_default(tau = .01, census_interval = 1)
  )

\donttest{
data("example_model")
model <- example_model \%>\% generate_gold_standard()
  
plot_gold_simulations(model)
plot_gold_mappings(model)
plot_gold_expression(model)
}
}
\seealso{
\link{dyngen} on how to run a complete dyngen simulation
}
