% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{which_max_nm}
\alias{which_max_nm}
\title{Return (Row, Column) Index of (First) Maximum of a Numeric Matrix}
\usage{
which_max_nm(x)
}
\arguments{
\item{x}{Numeric matrix.}
}
\value{
Integer vector.
}
\description{
Written in C++, this function tends to run much faster than the equivalent 
(if maximum is unique) base R solution 
\code{which(x == max(x), arr.ind = TRUE)}.
}
\details{
For optimal speed, choose the version of this function that matches the 
class of your \code{x}:

\code{\link{which_max_nv}} for numeric vector. \cr
\code{\link{which_max_iv}} for integer vector. \cr
\code{\link{which_max_nm}} for numeric matrix. \cr
\code{\link{which_max_im}} for integer matrix.
}
\examples{
# which_max_nm is typically much faster than 
# which(x == max(x), arr.ind = TRUE)
x <- matrix(rnorm(100), ncol = 10)
all(which(x == max(x), arr.ind = TRUE) == which_max_nm(x))
benchmark(which(x == max(x), arr.ind = TRUE), which_max_nm(x),
          replications = 5000)

}
