% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moving_mean.R
\name{moving_mean}
\alias{moving_mean}
\title{Moving Averages}
\usage{
moving_mean(x, window, integer = FALSE, max = FALSE)
}
\arguments{
\item{x}{Integer or numeric vector.}

\item{window}{Integer value specifying window length.}

\item{integer}{Logical value for whether \code{x} is an integer vector.}

\item{max}{Logical value for whether to return maximum moving average (as 
opposed to vector of moving averages).}
}
\value{
Numeric value or vector depending on \code{max}.
}
\description{
Calculates moving averages or maximum moving average. For optimal speed, use 
\code{integer = TRUE} if \code{x} is an integer vector and 
\code{integer = FALSE} otherwise.
}
\examples{
# 5-unit moving average for integer vector of length 10
x <- rpois(10, lambda = 3)
moving_mean(x, 5)


}
