% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mle_lnorm.R
\name{mle_lnorm}
\alias{mle_lnorm}
\title{Maximum Likelihood Estimation for X[1], ..., X[n] ~ Lognormal(mu, sigsq)}
\usage{
mle_lnorm(x, mu = NULL, sigsq = NULL, estimate_var = FALSE, ...)
}
\arguments{
\item{x}{Numeric vector.}

\item{mu}{Numeric value specifying known mu.}

\item{sigsq}{Numeric value specifying known sigsq.}

\item{estimate_var}{Logical value for whether to return Hessian-based
variance-covariance matrix.}

\item{...}{Additional arguments to pass to \code{\link[stats]{nlminb}}.}
}
\value{
List containing:
\enumerate{
\item Numeric vector of parameter estimates.
\item Variance-covariance matrix (if \code{estimate_var = TRUE}).
\item Returned \code{\link[stats]{nlminb}} object from maximizing the
log-likelihood function.
\item Akaike information criterion (AIC).
}
}
\description{
Performs maximization via \code{\link[stats]{nlminb}}. mu and sigsq 
correspond to meanlog and sdlog^2 in \code{\link[stats]{Lognormal}}.
}
\examples{
# Generate 1,000 values from Lognormal(0.5, 1) and estimate mu and sigsq
set.seed(123)
x <- rlnorm(1000, meanlog = 0.5, sdlog = sqrt(1))
mle_lnorm(x)


}
