% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dumbbell.R
\name{dumbbell}
\alias{dumbbell}
\title{Dumbbell Plot}
\usage{
dumbbell(
  xdf,
  id,
  key,
  column1,
  column2,
  lab1,
  lab2,
  title,
  pointsize,
  textsize,
  segsize,
  expandx,
  expandy,
  p_col1,
  p_col2,
  leg,
  col_seg1,
  col_seg2,
  col_lab1,
  col_lab2,
  pt_alpha,
  arrow_size,
  arrow,
  pt_val,
  delt,
  pval
)
}
\arguments{
\item{xdf}{data a data frame, \code{xdf= data frame}
A data frame containing at least four columns
corresponding, respectively, to (1) the first variable containing the "id",
(2) the second variable containing the "key" , (3) the third variable containing the start of the point "column1", the first data series,
(4) the fourth variable containing the end of the point "column2", the second data series}

\item{id}{is the name of the column containing the id variable which will label the y axis eg(subject1,subject2 etc) eg \code{id = "id"}}

\item{key}{is the name of the column containing the key variable telling us which measure we use in each row eg \code{key = "key"}}

\item{column1, column2}{first and second series of data eg \code{column1 = "Control"} \code{column2 = "Test"}}

\item{lab1, lab2}{labels for data series eg \code{lab1 = "Test"} \code{lab2 = "Control"}}

\item{title}{Adds title to the plot eg \code{title = "This is a plot title"}}

\item{pointsize}{Adds pointsize to the points eg \code{pointsize = 3}}

\item{textsize}{numeric value specifying the text size eg \code{textsize = 3}}

\item{segsize}{numeric value specifying the segment width eg \code{segsize = 1}}

\item{expandx}{Add space to the both ends of the x axis eg \code{expandx = 0.6}}

\item{expandy}{Add space to the both ends of the y axis eg \code{expandy = 1}}

\item{p_col1, p_col2}{colors for start and end points eg \code{pcol1 = "red"}}

\item{leg}{Add legend title \code{legend = "legend title"}}

\item{col_seg1, col_seg2}{Adds a color to each arrow in each direction eg \code{col_seg1 = "red"}}

\item{col_lab1, col_lab2}{color text below each dumbell eg \code{col_lab1 = "red"}}

\item{pt_alpha}{Add transparentcy to points \code{pt_alpha = 0.6}}

\item{arrow_size}{Add size to arrows \code{arrow_size = 0.2}}

\item{arrow}{Adds an arrow to one end of the dumbbell eg \code{arrow = 1}}

\item{pt_val}{Add option to show the point values eg \code{pt_val = 1}}

\item{delt}{Add a delta column to the plot eg \code{delt = 1}}

\item{pval}{Adds pvalue to the facet label, from using a wilcox paired test eg \code{pval = 1} or a paired t_test eg \code{pval = 2} (requires to use facet_wrap).}
}
\value{
Dumbbell plot
}
\description{
Draws a Dumbbell Plot, essentially a dot plot with two series of data.
}
\examples{
library(tidyverse)
library(ggplot2) 
library(rlang)
library(utils)
library(data.table)
library(dumbbell)
## create data
z<-data.frame(Group = c(rep("A",20),rep("B",20)),
              #  Subject = c(paste("sub_",1:20,sep=""),paste("sub_",1:20,sep="")),
              Subject = c(paste(1:20,sep=""),paste(1:20,sep="")),
              result = c(sample(1:100000, 40, replace=TRUE)),
              analysis = c(rep("a",10),rep("b",10) ,rep("b",10),rep("a",10) )
              
)

b<-z \%>\% filter(Group == 'A')
c<-z \%>\% filter(Group == 'B')

d<-merge(b,c, by.x="Subject", by.y = "Subject")


e<-d \%>\% mutate("diff"=result.x-result.y) \%>\% arrange(diff)





d$Subject<-factor(d$Subject, levels = e$Subject)


## Basic plot
dumbbell(xdf=d,id= "Subject",key="analysis.x",column1 = "result.x",column2 = "result.y") 
}
\author{
Foo Cheung, \email{foocheung@yahoo.com}
}
\keyword{dumbbell}
